/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.report;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.image.ImageOpt;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.PieChart;
import org.knowm.xchart.PieChartBuilder;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.colors.ChartColor;
import org.knowm.xchart.style.markers.SeriesMarkers;
import org.knowm.xchart.style.markers.XChartSeriesMarkers;

public abstract class ChartImageUtils {
    public static final String CHART_TYPE_BAR = "bar";
    public static final String CHART_TYPE_LINE = "line";
    public static final String CHART_TYPE_PIE = "pie";
    public static final Color[] COLORS = new Color[]{new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(0, 128, 128), new Color(0, 255, 255), new Color(150, 60, 103), new Color(255, 0, 255), new Color(255, 128, 0), new Color(128, 128, 0), new Color(128, 0, 128), new Color(255, 255, 0)};

    public static Chart<?, ?> createChart(String chartType, String chartTitle, int width, int height, JSONObject data, JSONObject style) {
        if (CHART_TYPE_BAR.equals(chartType)) {
            return ChartImageUtils.createBarChart(chartTitle, width, height, style, data);
        }
        if (CHART_TYPE_LINE.equals(chartType)) {
            return ChartImageUtils.createLineChart(chartTitle, width, height, style, data);
        }
        if (CHART_TYPE_PIE.equals(chartType)) {
            return ChartImageUtils.createPieChart(chartTitle, width, height, style, data);
        }
        return null;
    }

    private static List<Number> castObjectToNumbers(Object obj, String errorMessage) {
        List series = CollectionsOpt.objectToList((Object)obj);
        if (series == null || series.isEmpty()) {
            throw new ObjectException(614, errorMessage);
        }
        ArrayList<Number> numbers = new ArrayList<Number>();
        for (Object o : series) {
            numbers.add(NumberBaseOpt.castObjectToNumber(o));
        }
        return numbers;
    }

    public static XYChart createLineChart(String chartTitle, int width, int height, JSONObject data, JSONObject style) {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(width)).height(height)).title(chartTitle)).xAxisTitle(data.getString("xAxisTitle")).yAxisTitle(data.getString("yAxisTitle")).build();
        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideN);
        ((XYStyler)chart.getStyler()).setLegendLayout(Styler.LegendLayout.Horizontal);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line);
        ((XYStyler)chart.getStyler()).setChartBackgroundColor(Color.WHITE);
        ((XYStyler)chart.getStyler()).setPlotBackgroundColor(ChartColor.GREY.getColor());
        ((XYStyler)chart.getStyler()).setPlotGridLinesColor(new Color(255, 255, 255));
        ((XYStyler)chart.getStyler()).setChartTitleBoxBackgroundColor(new Color(0, 0, 0, 50));
        ((XYStyler)chart.getStyler()).setChartTitleBoxVisible(true);
        ((XYStyler)chart.getStyler()).setChartTitleBoxBorderColor(Color.BLACK);
        ((XYStyler)chart.getStyler()).setAxisTickLabelsColor(Color.DARK_GRAY);
        ((XYStyler)chart.getStyler()).setPlotBorderVisible(false);
        ((XYStyler)chart.getStyler()).setMarkerSize(10);
        if (style != null) {
            for (Map.Entry entry : style.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "legendPosition": {
                        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.valueOf((String)entry.getValue().toString()));
                        break;
                    }
                    case "legendLayout": {
                        ((XYStyler)chart.getStyler()).setLegendLayout(Styler.LegendLayout.valueOf((String)entry.getValue().toString()));
                        break;
                    }
                    case "defaultSeriesRenderStyle": {
                        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.valueOf((String)entry.getValue().toString()));
                        break;
                    }
                    case "chartBackgroundColor": {
                        ((XYStyler)chart.getStyler()).setChartBackgroundColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "plotBackgroundColor": {
                        ((XYStyler)chart.getStyler()).setPlotBackgroundColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "plotGridLinesColor": {
                        ((XYStyler)chart.getStyler()).setPlotGridLinesColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "chartTitleBoxBackgroundColor": {
                        ((XYStyler)chart.getStyler()).setChartTitleBoxBackgroundColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "chartTitleBoxVisible": {
                        ((XYStyler)chart.getStyler()).setChartTitleBoxVisible(BooleanBaseOpt.castObjectToBoolean(entry.getValue(), (Boolean)true).booleanValue());
                        break;
                    }
                    case "chartTitleBoxBorderColor": {
                        ((XYStyler)chart.getStyler()).setChartTitleBoxBorderColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "axisTickLabelsColor": {
                        ((XYStyler)chart.getStyler()).setAxisTickLabelsColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "plotBorderVisible": {
                        ((XYStyler)chart.getStyler()).setPlotBorderVisible(BooleanBaseOpt.castObjectToBoolean(entry.getValue(), (Boolean)true).booleanValue());
                        break;
                    }
                    case "markerSize": {
                        ((XYStyler)chart.getStyler()).setMarkerSize(NumberBaseOpt.castObjectToInteger(entry.getValue()).intValue());
                    }
                }
            }
        }
        Object obj = data.get("xData");
        List<Number> xData = ChartImageUtils.castObjectToNumbers(obj, "data.xData \u683c\u5f0f\u4e0d\u6b63\u786e, \u4e0d\u80fd\u4f5c\u4e3aX\u8f74\u6570\u636e");
        obj = data.get("series");
        XChartSeriesMarkers seriesMarkers = new XChartSeriesMarkers();
        int seriesCount = seriesMarkers.getSeriesMarkers().length;
        if (obj instanceof JSONArray) {
            JSONArray seriesArray = (JSONArray)obj;
            for (int i = 0; i < seriesArray.size(); ++i) {
                JSONObject series = seriesArray.getJSONObject(i);
                String name = series.getString("name");
                List<Number> yData = ChartImageUtils.castObjectToNumbers(series.get("data"), "data.series \u683c\u5f0f\u4e0d\u6b63\u786e, \u4e0d\u80fd\u4f5c\u4e3a\u6570\u636e");
                chart.addSeries(name, xData, yData).setMarker(seriesMarkers.getSeriesMarkers()[i % seriesCount]).setLineColor(COLORS[i % COLORS.length]);
            }
        } else if (obj instanceof JSONObject) {
            JSONObject series = (JSONObject)obj;
            String name = series.getString("name");
            List<Number> yData = ChartImageUtils.castObjectToNumbers(series.get("data"), "data.series \u683c\u5f0f\u4e0d\u6b63\u786e, \u4e0d\u80fd\u4f5c\u4e3a\u6570\u636e");
            chart.addSeries(name, xData, yData).setMarker(SeriesMarkers.CIRCLE).setLineColor(new Color(255, 0, 0));
        } else {
            throw new ObjectException(614, "data.series \u683c\u5f0f\u4e0d\u6b63\u786e, \u4e0d\u80fd\u4f5c\u4e3a\u6570\u636e\u7cfb\u5217");
        }
        return chart;
    }

    public static PieChart createPieChart(String chartTitle, int width, int height, JSONObject data, JSONObject style) {
        Object obj;
        PieChart chart = ((PieChartBuilder)((PieChartBuilder)((PieChartBuilder)new PieChartBuilder().width(width)).height(height)).title(chartTitle)).build();
        ((PieStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideN);
        if (style != null) {
            for (Map.Entry entry : style.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "legendPosition": {
                        ((PieStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.valueOf((String)entry.getValue().toString()));
                        break;
                    }
                    case "legendLayout": {
                        ((PieStyler)chart.getStyler()).setLegendLayout(Styler.LegendLayout.valueOf((String)entry.getValue().toString()));
                        break;
                    }
                    case "defaultSeriesRenderStyle": {
                        ((PieStyler)chart.getStyler()).setDefaultSeriesRenderStyle(PieSeries.PieSeriesRenderStyle.valueOf((String)entry.getValue().toString()));
                        break;
                    }
                    case "plotBackgroundColor": {
                        ((PieStyler)chart.getStyler()).setPlotBackgroundColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "chartBackgroundColor": {
                        ((PieStyler)chart.getStyler()).setChartBackgroundColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "chartTitleBoxBackgroundColor": {
                        ((PieStyler)chart.getStyler()).setChartTitleBoxBackgroundColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "chartTitleBoxVisible": {
                        ((PieStyler)chart.getStyler()).setChartTitleBoxVisible(BooleanBaseOpt.castObjectToBoolean(entry.getValue(), (Boolean)true).booleanValue());
                        break;
                    }
                    case "chartTitleBoxBorderColor": {
                        ((PieStyler)chart.getStyler()).setChartTitleBoxBorderColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "plotBorderVisible": {
                        ((PieStyler)chart.getStyler()).setPlotBorderVisible(BooleanBaseOpt.castObjectToBoolean(entry.getValue(), (Boolean)true).booleanValue());
                        break;
                    }
                    case "markerSize": {
                        ((PieStyler)chart.getStyler()).setMarkerSize(NumberBaseOpt.castObjectToInteger(entry.getValue(), (Integer)10).intValue());
                        break;
                    }
                    case "plotContentSize": {
                        ((PieStyler)chart.getStyler()).setPlotContentSize(NumberBaseOpt.castObjectToDouble(entry.getValue(), (Double)0.7).doubleValue());
                    }
                }
            }
        }
        if ((obj = data.get("series")) instanceof JSONArray) {
            JSONArray seriesArray = (JSONArray)obj;
            for (int i = 0; i < seriesArray.size(); ++i) {
                JSONObject series = seriesArray.getJSONObject(i);
                chart.addSeries(series.getString("name"), NumberBaseOpt.castObjectToNumber((Object)series.get("value")));
            }
        }
        return chart;
    }

    public static CategoryChart createBarChart(String chartTitle, int width, int height, JSONObject data, JSONObject style) {
        Object obj;
        List xData;
        CategoryChart chart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(width)).height(height)).title(chartTitle)).xAxisTitle(data.getString("xAxisTitle")).yAxisTitle(data.getString("yAxisTitle")).build();
        ((CategoryStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideN);
        ((CategoryStyler)chart.getStyler()).setLegendLayout(Styler.LegendLayout.Horizontal);
        ((CategoryStyler)chart.getStyler()).setDefaultSeriesRenderStyle(CategorySeries.CategorySeriesRenderStyle.Bar);
        ((CategoryStyler)chart.getStyler()).setStacked(true);
        ((CategoryStyler)chart.getStyler()).setPlotBackgroundColor(ChartColor.DARK_GREY.getColor());
        ((CategoryStyler)chart.getStyler()).setChartBackgroundColor(Color.WHITE);
        ((CategoryStyler)chart.getStyler()).setPlotGridLinesVisible(true);
        ((CategoryStyler)chart.getStyler()).setPlotGridLinesColor(new Color(220, 220, 220));
        ((CategoryStyler)chart.getStyler()).setXAxisLabelRotation(45);
        if (style != null) {
            for (Map.Entry entry : style.entrySet()) {
                switch ((String)entry.getKey()) {
                    case "legendPosition": {
                        ((CategoryStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.valueOf((String)entry.getValue().toString()));
                        break;
                    }
                    case "legendLayout": {
                        ((CategoryStyler)chart.getStyler()).setLegendLayout(Styler.LegendLayout.valueOf((String)entry.getValue().toString()));
                        break;
                    }
                    case "defaultSeriesRenderStyle": {
                        ((CategoryStyler)chart.getStyler()).setDefaultSeriesRenderStyle(CategorySeries.CategorySeriesRenderStyle.valueOf((String)entry.getValue().toString()));
                        break;
                    }
                    case "plotBackgroundColor": {
                        ((CategoryStyler)chart.getStyler()).setPlotBackgroundColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "chartBackgroundColor": {
                        ((CategoryStyler)chart.getStyler()).setChartBackgroundColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "chartTitleBoxBackgroundColor": {
                        ((CategoryStyler)chart.getStyler()).setChartTitleBoxBackgroundColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "chartTitleBoxVisible": {
                        ((CategoryStyler)chart.getStyler()).setChartTitleBoxVisible(BooleanBaseOpt.castObjectToBoolean(entry.getValue(), (Boolean)true).booleanValue());
                        break;
                    }
                    case "chartTitleBoxBorderColor": {
                        ((CategoryStyler)chart.getStyler()).setChartTitleBoxBorderColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "plotBorderVisible": {
                        ((CategoryStyler)chart.getStyler()).setPlotBorderVisible(BooleanBaseOpt.castObjectToBoolean(entry.getValue(), (Boolean)true).booleanValue());
                        break;
                    }
                    case "markerSize": {
                        ((CategoryStyler)chart.getStyler()).setMarkerSize(NumberBaseOpt.castObjectToInteger(entry.getValue(), (Integer)10).intValue());
                        break;
                    }
                    case "plotContentSize": {
                        ((CategoryStyler)chart.getStyler()).setPlotContentSize(NumberBaseOpt.castObjectToDouble(entry.getValue(), (Double)0.7).doubleValue());
                        break;
                    }
                    case "plotGridLinesVisible": {
                        ((CategoryStyler)chart.getStyler()).setPlotGridLinesVisible(BooleanBaseOpt.castObjectToBoolean(entry.getValue(), (Boolean)true).booleanValue());
                        break;
                    }
                    case "plotGridLinesColor": {
                        ((CategoryStyler)chart.getStyler()).setPlotGridLinesColor(ImageOpt.castObjectToColor(entry.getValue()));
                        break;
                    }
                    case "xAxisLabelRotation": {
                        ((CategoryStyler)chart.getStyler()).setXAxisLabelRotation(NumberBaseOpt.castObjectToInteger(entry.getValue(), (Integer)45).intValue());
                        break;
                    }
                    case "yAxisGroupTitle": {
                        chart.setYAxisGroupTitle(NumberBaseOpt.castObjectToInteger(entry.getValue(), (Integer)0).intValue(), entry.getValue().toString());
                    }
                }
            }
        }
        if ((xData = CollectionsOpt.objectToList((Object)(obj = data.get("xData")))) == null || xData.isEmpty()) {
            throw new ObjectException(614, "data.xData is not Array, \u4e0d\u80fd\u4f5c\u4e3a\u6a2a\u5750\u6807\u6570\u636e");
        }
        obj = data.get("series");
        if (obj instanceof JSONArray) {
            JSONArray seriesArray = (JSONArray)obj;
            for (int i = 0; i < seriesArray.size(); ++i) {
                JSONObject series = seriesArray.getJSONObject(i);
                String name = series.getString("name");
                List<Number> yData = ChartImageUtils.castObjectToNumbers(series.get("data"), "data.series \u683c\u5f0f\u4e0d\u6b63\u786e, \u4e0d\u80fd\u4f5c\u4e3a\u6570\u636e");
                chart.addSeries(name, xData, yData).setFillColor(COLORS[i % COLORS.length]);
            }
        } else if (obj instanceof JSONObject) {
            JSONObject series = (JSONObject)obj;
            String name = series.getString("name");
            List<Number> yData = ChartImageUtils.castObjectToNumbers(series.get("data"), "data.series \u683c\u5f0f\u4e0d\u6b63\u786e, \u4e0d\u80fd\u4f5c\u4e3a\u6570\u636e");
            chart.addSeries(name, xData, yData).setFillColor(new Color(255, 0, 0));
        } else {
            throw new ObjectException(614, "data.series \u683c\u5f0f\u4e0d\u6b63\u786e, \u4e0d\u80fd\u4f5c\u4e3a\u6570\u636e\u7cfb\u5217");
        }
        return chart;
    }

    public static BufferedImage createChartImage(String chartType, String chartTitle, int width, int height, JSONObject data, JSONObject style) {
        Chart<?, ?> chart = ChartImageUtils.createChart(chartType, chartTitle, width, height, data, style);
        if (chart == null) {
            return null;
        }
        return BitmapEncoder.getBufferedImage(chart);
    }
}

