/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.report;

import com.centit.support.algorithm.ByteBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import fr.opensagres.xdocreport.document.images.ByteArrayImageProvider;
import fr.opensagres.xdocreport.document.images.IImageProvider;
import fr.opensagres.xdocreport.template.IContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JsonDocxContext
implements IContext {
    private Map<String, Object> docObject;

    public JsonDocxContext() {
        this.docObject = null;
    }

    public JsonDocxContext(Object object) {
        this.docObject = CollectionsOpt.objectToMap((Object)object);
    }

    public Object put(String key, Object value) {
        if (this.docObject == null) {
            this.docObject = new HashMap<String, Object>();
        }
        return this.docObject.put(key, value);
    }

    public Object get(String key) {
        Object value = null;
        if (this.docObject != null && (value = ReflectionOpt.attainExpressionValue(this.docObject, (String)key)) == null && key.startsWith("img_")) {
            value = ReflectionOpt.attainExpressionValue(this.docObject, (String)key.substring(4));
        }
        if (value == null || key.startsWith("___")) {
            return value;
        }
        if (value instanceof IImageProvider) {
            return value;
        }
        if (value instanceof byte[]) {
            if (key.startsWith("img_")) {
                return new ByteArrayImageProvider((byte[])value);
            }
            return StringBaseOpt.castObjectToString((Object)value);
        }
        if (value instanceof Collection) {
            Collection objects = (Collection)value;
            ArrayList<JsonDocxContext> valueList = new ArrayList<JsonDocxContext>(objects.size());
            for (Object obj : objects) {
                if (obj instanceof Map) {
                    valueList.add(new JsonDocxContext(obj));
                    continue;
                }
                valueList.add((JsonDocxContext)obj);
            }
            return valueList;
        }
        if (value.getClass().isArray()) {
            if (key.startsWith("img_")) {
                return new ByteArrayImageProvider(ByteBaseOpt.castObjectToBytes((Object)value));
            }
            int len = Array.getLength(value);
            ArrayList<Object> valueList = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(value, i);
                if (obj instanceof Map) {
                    valueList.add(new JsonDocxContext(obj));
                    continue;
                }
                valueList.add(obj);
            }
            return valueList;
        }
        if (value instanceof Map) {
            return new JsonDocxContext(value);
        }
        return value;
    }

    public void putMap(Map<String, Object> contextMap) {
        if (this.docObject == null) {
            this.docObject = new HashMap<String, Object>();
        }
        this.docObject.putAll(contextMap);
    }

    public Map<String, Object> getContextMap() {
        return this.docObject;
    }

    public String toString() {
        return StringBaseOpt.castObjectToString(this.docObject, (String)"");
    }
}

