/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.report;

import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.compiler.EmbedFuncUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.jxls.common.Context;
import org.jxls.expression.JexlExpressionEvaluator;
import org.jxls.transform.Transformer;
import org.jxls.util.JxlsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelReportUtil {
    protected static final Logger logger = LoggerFactory.getLogger(ExcelReportUtil.class);

    private ExcelReportUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static void exportExcel(InputStream is, OutputStream os, Map<String, Object> model, Map<String, Object> extendFuns) throws IOException {
        Context context = new Context(model);
        Map extFuns = CollectionsOpt.createHashMap((Object[])new Object[]{"utils", EmbedFuncUtils.instance});
        if (extendFuns != null) {
            extFuns.putAll(extendFuns);
        }
        JexlBuilder jb = new JexlBuilder();
        jb.namespaces(extFuns);
        JexlEngine je = jb.create();
        JxlsHelper jxlsHelper = JxlsHelper.getInstance();
        Transformer transformer = jxlsHelper.createTransformer(is, os);
        JexlExpressionEvaluator evaluator = (JexlExpressionEvaluator)transformer.getTransformationConfig().getExpressionEvaluator();
        evaluator.setJexlEngine(je);
        jxlsHelper.processTemplate(context, transformer);
    }

    public static void exportExcel(InputStream is, OutputStream os, Map<String, Object> model) throws IOException {
        ExcelReportUtil.exportExcel(is, os, model, null);
    }
}

