/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.office.OfficeToPdf;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public abstract class Watermark4Pdf {
    public static boolean runFlag = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addWatermark(String inputFile, String waterMarkStr) {
        PdfContentByte content = null;
        BaseFont base = null;
        Rectangle pageRect = null;
        PdfGState gs = new PdfGState();
        PdfReader pdfReader = null;
        PdfStamper pdfStamper = null;
        FileOutputStream outf = null;
        String tmpPdfFile = inputFile.substring(0, inputFile.lastIndexOf(".")) + Watermark4Pdf.getTimestamp() + ".pdf";
        String wartermarkFile = inputFile.substring(0, inputFile.lastIndexOf(".")) + ".pdf";
        try {
            if (OfficeToPdf.office2Pdf(inputFile, tmpPdfFile)) {
                pdfReader = new PdfReader(tmpPdfFile);
                outf = new FileOutputStream(wartermarkFile);
                pdfStamper = new PdfStamper(pdfReader, (OutputStream)outf);
            }
        }
        catch (DocumentException | IOException e1) {
            e1.printStackTrace();
            return false;
        }
        try {
            base = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            if (base == null || pdfStamper == null) {
                boolean e = false;
                return e;
            }
            gs.setFillOpacity(0.4f);
            gs.setStrokeOpacity(0.4f);
            int toPage = pdfStamper.getReader().getNumberOfPages();
            for (int i = 1; i <= toPage; ++i) {
                pageRect = pdfStamper.getReader().getPageSizeWithRotation(i);
                float x = pageRect.getWidth() / 2.0f;
                float y = pageRect.getHeight() / 2.0f;
                content = pdfStamper.getOverContent(i);
                content.saveState();
                content.setGState(gs);
                content.beginText();
                content.setColorFill(BaseColor.GRAY);
                content.setFontAndSize(base, 60.0f);
                content.showTextAligned(1, waterMarkStr, x, y, 45.0f);
                content.endText();
            }
            System.out.println("\u4e3aPDF\u6587\u4ef6\u6dfb\u52a0\u6c34\u5370\u5b8c\u6210\uff01");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            content = null;
            base = null;
            pageRect = null;
            try {
                pdfStamper.close();
                pdfReader.close();
                ((OutputStream)outf).close();
            }
            catch (DocumentException | IOException e) {
                e.printStackTrace();
                return false;
            }
            try {
                File fs = new File(tmpPdfFile);
                if (fs.exists()) {
                    fs.delete();
                    fs = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addWatermark(String inputFile, String outputFile, String waterMarkStr, String opacity, String rotation, String fontSize) {
        PdfContentByte content = null;
        BaseFont base = null;
        Rectangle pageRect = null;
        PdfGState gs = new PdfGState();
        PdfReader pdfReader = null;
        PdfStamper pdfStamper = null;
        String tmpPdfFile = inputFile.substring(0, inputFile.lastIndexOf(".")) + Watermark4Pdf.getTimestamp() + ".pdf";
        String wartermarkFile = outputFile;
        if (outputFile == null || outputFile.equals("")) {
            wartermarkFile = inputFile.substring(0, inputFile.lastIndexOf(".")) + ".pdf";
        }
        try {
            if (OfficeToPdf.office2Pdf(inputFile, tmpPdfFile)) {
                pdfReader = new PdfReader(tmpPdfFile);
                pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(wartermarkFile));
            }
        }
        catch (DocumentException | IOException e1) {
            e1.printStackTrace();
            return false;
        }
        try {
            base = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            if (base == null || pdfStamper == null) {
                boolean e = false;
                return e;
            }
            gs.setFillOpacity(Float.valueOf(opacity).floatValue());
            gs.setStrokeOpacity(Float.valueOf(opacity).floatValue());
            int toPage = pdfStamper.getReader().getNumberOfPages();
            for (int i = 1; i <= toPage; ++i) {
                pageRect = pdfStamper.getReader().getPageSizeWithRotation(i);
                float x = pageRect.getWidth() / 2.0f;
                float y = pageRect.getHeight() / 2.0f;
                content = pdfStamper.getOverContent(i);
                content.saveState();
                content.setGState(gs);
                content.beginText();
                content.setColorFill(BaseColor.GRAY);
                content.setFontAndSize(base, (float)Integer.parseInt(fontSize));
                content.showTextAligned(1, waterMarkStr, x, y, (float)Integer.valueOf(rotation).intValue());
                content.endText();
            }
            System.out.println("\u4e3aPDF\u6587\u4ef6\u6dfb\u52a0\u6c34\u5370\u5b8c\u6210\uff01");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            content = null;
            base = null;
            pageRect = null;
            try {
                pdfStamper.close();
                pdfReader.close();
            }
            catch (DocumentException | IOException e) {
                e.printStackTrace();
                return false;
            }
            try {
                File fs = new File(tmpPdfFile);
                if (fs.exists()) {
                    fs.deleteOnExit();
                    fs = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static String getTimestamp() {
        return DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"yyyyMMddHHmmssSSS");
    }
}

