/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.File;
import jp.ne.so_net.ga2.no_ji.jcom.IDispatch;
import jp.ne.so_net.ga2.no_ji.jcom.ReleaseManager;

public abstract class OfficeToPdf {
    private static final int ppSaveAsPDF = 32;

    public static boolean excel2PDF(String inputFile, String pdfFile) {
        ComThread.InitSTA();
        ActiveXComponent actcom = new ActiveXComponent("Excel.Application");
        try {
            actcom.setProperty("Visible", new Variant(false));
            Dispatch excels = actcom.getProperty("Workbooks").toDispatch();
            Dispatch excel = Dispatch.invoke((Dispatch)excels, (String)"Open", (int)1, (Object[])new Object[]{inputFile, new Variant(false), new Variant(false)}, (int[])new int[9]).toDispatch();
            Dispatch.invoke((Dispatch)excel, (String)"SaveAs", (int)1, (Object[])new Object[]{pdfFile, new Variant(57), new Variant(false), new Variant(57), new Variant(57), new Variant(false), new Variant(true), new Variant(57), new Variant(false), new Variant(true), new Variant(false)}, (int[])new int[1]);
            Dispatch.call((Dispatch)excel, (String)"Close", (Object)new Variant(false));
            if (actcom != null) {
                actcom.invoke("Quit", new Variant[0]);
                actcom = null;
            }
            ComThread.Release();
            System.out.println("excel\u8f6c\u6362\u4e3aPDF\u5b8c\u6210\uff01");
            return true;
        }
        catch (Exception es) {
            es.printStackTrace();
            return false;
        }
    }

    public static boolean ppt2PDF(String inputFile, String pdfFile) {
        try {
            ActiveXComponent app = new ActiveXComponent("PowerPoint.Application");
            Dispatch ppts = app.getProperty("Presentations").toDispatch();
            Dispatch ppt = Dispatch.call((Dispatch)ppts, (String)"Open", (Object)inputFile, (Object)true, (Object)true, (Object)false).toDispatch();
            Dispatch.call((Dispatch)ppt, (String)"SaveAs", (Object)pdfFile, (Object)32);
            Dispatch.call((Dispatch)ppt, (String)"Close");
            app.invoke("Quit");
            System.out.println("ppt\u8f6c\u6362\u4e3aPDF\u5b8c\u6210\uff01");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean word2PDF(String inputFile, String pdfFile) {
        ReleaseManager rm = null;
        IDispatch app = null;
        try {
            rm = new ReleaseManager();
            app = new IDispatch(rm, "Word.Application");
            app.put("Visible", (Object)false);
            IDispatch docs = (IDispatch)app.get("Documents");
            IDispatch doc = (IDispatch)docs.method("Open", new Object[]{inputFile, false, true});
            doc.method("SaveAs", new Object[]{pdfFile, 17});
            doc.method("Close", new Object[]{false});
            app.method("Quit", null);
            System.out.println("word\u8f6c\u6362\u4e3aPDF\u5b8c\u6210\uff01");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                app = null;
                rm.release();
                rm = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean office2Pdf(String inputFile, String pdfFile) {
        String suffix = inputFile.substring(inputFile.lastIndexOf(".") + 1).toLowerCase();
        File file = new File(inputFile);
        if (!file.exists()) {
            System.err.println("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return false;
        }
        if (suffix.equals("pdf")) {
            System.out.println("PDF\u6587\u4ef6\u65e0\u9700\u8f6c\u6362\u4e3aPDF!");
            return false;
        }
        if (suffix.equals("doc") || suffix.equals("docx")) {
            return OfficeToPdf.word2PDF(inputFile, pdfFile);
        }
        if (suffix.equals("ppt") || suffix.equals("pptx")) {
            return OfficeToPdf.ppt2PDF(inputFile, pdfFile);
        }
        if (suffix.equals("xls") || suffix.equals("xlsx")) {
            return OfficeToPdf.excel2PDF(inputFile, pdfFile);
        }
        System.out.println("\u6587\u4ef6\u683c\u5f0f\u4e0d\u652f\u6301\u8f6c\u6362\u4e3aPDF!");
        return false;
    }
}

