/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.office.commons.SignatureInfo;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.PrivateKeySignature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PdfSignatureUtil {
    private static final Logger logger = LogManager.getLogger(PdfSignatureUtil.class);

    public static SignatureInfo createSingInfo() {
        return new SignatureInfo();
    }

    public static boolean sign(InputStream srcStream, OutputStream targetStream, SignatureInfo signatureInfo) {
        try {
            ByteArrayOutputStream tempArrayOutputStream = new ByteArrayOutputStream();
            PdfReader reader = new PdfReader(srcStream);
            PdfStamper stamper = PdfStamper.createSignature((PdfReader)reader, (OutputStream)tempArrayOutputStream, (char)'\u0000', null, (boolean)true);
            PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
            appearance.setReason(signatureInfo.getReasonDesc());
            appearance.setLocation(signatureInfo.getLocationDesc());
            appearance.setVisibleSignature(signatureInfo.getSignRect(), signatureInfo.getSignPage(), signatureInfo.getFieldName());
            appearance.setSignatureGraphic(signatureInfo.getSignImage());
            appearance.setCertificationLevel(signatureInfo.getCertificationLevel());
            appearance.setRenderingMode(signatureInfo.getRenderingMode());
            BouncyCastleDigest digest = new BouncyCastleDigest();
            PrivateKeySignature signature = new PrivateKeySignature(signatureInfo.getPk(), signatureInfo.getDigestAlgorithm(), null);
            MakeSignature.signDetached((PdfSignatureAppearance)appearance, (ExternalDigest)digest, (ExternalSignature)signature, (Certificate[])signatureInfo.getChain(), null, null, null, (int)0, (MakeSignature.CryptoStandard)MakeSignature.CryptoStandard.CADES);
            targetStream.write(tempArrayOutputStream.toByteArray());
            targetStream.flush();
            return true;
        }
        catch (DocumentException | IOException | GeneralSecurityException e) {
            logger.error(e.getMessage(), e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean sign(String src, String target, SignatureInfo signatureInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

