/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.file.FileType;
import com.centit.support.office.commons.CommonUtils;
import com.centit.support.office.commons.Excel2PdfUtils;
import com.centit.support.office.commons.PDFPageEvent;
import com.centit.support.office.commons.PowerPointUtils;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.pdf.PdfConverter;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfficeToPdf {
    private static final Logger logger = LoggerFactory.getLogger(OfficeToPdf.class);
    static final String DOC = "doc";
    static final String DOCX = "docx";

    private OfficeToPdf() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean ppt2Pdf(String inPptFile, String outPdfFile, String suffix) {
        String pdfFile;
        String inputFile = CommonUtils.mapWidowsPathIfNecessary(inPptFile);
        return "ok".equals(PowerPointUtils.pptToPdfUseImage(inputFile, pdfFile = CommonUtils.mapWidowsPathIfNecessary(outPdfFile), suffix));
    }

    public static boolean ppt2Pdf(String inPptFile, String outPdfFile) {
        return OfficeToPdf.ppt2Pdf(inPptFile, outPdfFile, FileType.getFileExtName((String)inPptFile));
    }

    public static boolean word2Pdf(InputStream inWordStream, OutputStream outPdfStram, String suffix) {
        try {
            if (DOCX.equalsIgnoreCase(suffix)) {
                XWPFDocument docx = new XWPFDocument(inWordStream);
                PdfOptions options = PdfOptions.create();
                HashMap fontMap = new HashMap();
                options.fontProvider((familyName, encoding, size, style, color) -> {
                    try {
                        BaseFont bfChinese = (BaseFont)fontMap.get(familyName);
                        if (bfChinese == null) {
                            bfChinese = familyName.indexOf("\u4eff") >= 0 ? BaseFont.createFont((String)"simfang.ttf", (String)"Identity-H", (boolean)false) : (familyName.indexOf("\u5b8b") >= 0 ? BaseFont.createFont((String)"simsun.ttf", (String)"Identity-H", (boolean)false) : (familyName.indexOf("\u6977") >= 0 ? BaseFont.createFont((String)"simkai.ttf", (String)"Identity-H", (boolean)false) : BaseFont.createFont((String)"simhei.ttf", (String)"Identity-H", (boolean)false)));
                            fontMap.put(familyName, bfChinese);
                        }
                        Font fontChinese = new Font(bfChinese, size, style, color);
                        fontChinese.setFamily(familyName);
                        return fontChinese;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                });
                PdfConverter.getInstance().convert(docx, outPdfStram, (Options)options);
            } else if (DOC.equalsIgnoreCase(suffix)) {
                // empty if block
            }
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean word2Pdf(String inWordFile, String outPdfFile, String suffix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean word2Pdf(String inWordFile, String outPdfFile) {
        return OfficeToPdf.word2Pdf(inWordFile, outPdfFile, FileType.getFileExtName((String)inWordFile));
    }

    public static boolean excel2Pdf(InputStream inWExcelStream, OutputStream outPdfStram) {
        try {
            Document document = new Document();
            document.setPageSize(PageSize.A4.rotate());
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outPdfStram);
            writer.setPageEvent((PdfPageEvent)new PDFPageEvent());
            document.open();
            Workbook wb = WorkbookFactory.create((InputStream)inWExcelStream);
            int nSheetSize = wb.getNumberOfSheets();
            if (nSheetSize > 1) {
                Excel2PdfUtils.toCreateContentIndexes(document, nSheetSize);
            }
            for (int i = 0; i < nSheetSize; ++i) {
                Sheet sheet = wb.getSheetAt(i);
                PdfPTable table = Excel2PdfUtils.toParseContent(wb, sheet, i);
                table.setKeepTogether(true);
                table.getDefaultCell().setBorder(0);
                document.add((Element)table);
            }
            document.close();
            return true;
        }
        catch (DocumentException | IOException e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean excel2Pdf(String inExcelFile, String outPdfFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

