/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ImagesToPdf {
    private static final Logger logger = LogManager.getLogger(ImagesToPdf.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image bufferedImageToPdfImage(BufferedImage image) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "JPG", outputStream);
            Image image2 = Image.getInstance((byte[])outputStream.toByteArray());
            return image2;
        }
        catch (BadElementException | IOException e) {
            return null;
        }
    }

    public static void bufferedImagesToA4SizePdf(List<BufferedImage> imageList, OutputStream outPdfStram) {
        ArrayList<Image> images = new ArrayList<Image>(imageList.size());
        for (BufferedImage image : imageList) {
            Image img = ImagesToPdf.bufferedImageToPdfImage(image);
            if (img == null) continue;
            images.add(img);
        }
        ImagesToPdf.imagesToA4SizePdf(images, outPdfStram);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void imagesToA4SizePdf(List<Image> imageList, OutputStream outPdfStram) {
        try (Document document = new Document(PageSize.A4, 0.0f, 0.0f, 0.0f, 0.0f);){
            PdfWriter.getInstance((Document)document, (OutputStream)outPdfStram);
            document.open();
            float a4Width = document.getPageSize().getWidth();
            float a4Height = document.getPageSize().getHeight();
            float imageWidth = imageList.get(0).getWidth();
            float imageHeight = imageList.get(0).getHeight();
            int rowTotalCount = (int)(a4Width / imageWidth);
            int totalRowCount = (int)(a4Height / imageHeight);
            int columnCount = 0;
            int rowCount = 1;
            for (int i = 0; i < imageList.size(); ++i) {
                Image image = imageList.get(i);
                image.setAlignment(1);
                if (columnCount >= rowTotalCount) {
                    ++rowCount;
                    columnCount = 0;
                }
                if (totalRowCount == 1 || rowCount > totalRowCount) {
                    document.setPageSize(new Rectangle(a4Width, a4Height));
                    document.newPage();
                    rowCount = 1;
                    columnCount = 0;
                }
                float xBlankTotalWidth = a4Width - imageWidth * (float)rowTotalCount;
                float xBlankWidth = xBlankTotalWidth / (float)(rowTotalCount + 1);
                float x = columnCount > 0 ? xBlankWidth * (float)(columnCount + 1) + imageWidth * (float)columnCount++ : xBlankWidth + imageWidth * (float)columnCount++;
                float yBlankTotalHeight = a4Height - imageHeight * (float)totalRowCount;
                float yBlankHeight = yBlankTotalHeight / (float)(totalRowCount + 1);
                float y = a4Height - imageHeight * (float)rowCount - yBlankHeight * (float)rowCount;
                image.setAbsolutePosition(x, y);
                document.add((Element)image);
            }
        }
    }
}

