/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxTransformXls {
    private int lastColumn = 0;
    private HashMap<Integer, HSSFCellStyle> styleMap = new HashMap();

    public void transformXSSF(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew) {
        workbookNew.setMissingCellPolicy(workbookOld.getMissingCellPolicy());
        for (int i = 0; i < workbookOld.getNumberOfSheets(); ++i) {
            XSSFSheet sheetOld = workbookOld.getSheetAt(i);
            HSSFSheet sheetNew = workbookNew.getSheet(sheetOld.getSheetName());
            if (sheetNew == null) {
                sheetNew = workbookNew.createSheet(sheetOld.getSheetName());
            }
            this.transform(workbookOld, workbookNew, sheetOld, sheetNew);
        }
    }

    private void transform(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, XSSFSheet sheetOld, HSSFSheet sheetNew) {
        int i;
        sheetNew.setDisplayFormulas(sheetOld.isDisplayFormulas());
        sheetNew.setDisplayGridlines(sheetOld.isDisplayGridlines());
        sheetNew.setDisplayGuts(sheetOld.getDisplayGuts());
        sheetNew.setDisplayRowColHeadings(sheetOld.isDisplayRowColHeadings());
        sheetNew.setDisplayZeros(sheetOld.isDisplayZeros());
        sheetNew.setFitToPage(sheetOld.getFitToPage());
        sheetNew.setHorizontallyCenter(sheetOld.getHorizontallyCenter());
        sheetNew.setMargin((short)3, sheetOld.getMargin((short)3));
        sheetNew.setMargin((short)5, sheetOld.getMargin((short)5));
        sheetNew.setMargin((short)4, sheetOld.getMargin((short)4));
        sheetNew.setMargin((short)0, sheetOld.getMargin((short)0));
        sheetNew.setMargin((short)1, sheetOld.getMargin((short)1));
        sheetNew.setMargin((short)2, sheetOld.getMargin((short)2));
        sheetNew.setPrintGridlines(sheetNew.isPrintGridlines());
        sheetNew.setRightToLeft(sheetNew.isRightToLeft());
        sheetNew.setRowSumsBelow(sheetNew.getRowSumsBelow());
        sheetNew.setRowSumsRight(sheetNew.getRowSumsRight());
        sheetNew.setVerticallyCenter(sheetOld.getVerticallyCenter());
        for (Row row : sheetOld) {
            HSSFRow rowNew = sheetNew.createRow(row.getRowNum());
            if (rowNew == null) continue;
            this.transform(workbookOld, workbookNew, (XSSFRow)row, rowNew);
        }
        for (i = 0; i < this.lastColumn; ++i) {
            sheetNew.setColumnWidth(i, sheetOld.getColumnWidth(i));
            sheetNew.setColumnHidden(i, sheetOld.isColumnHidden(i));
        }
        for (i = 0; i < sheetOld.getNumMergedRegions(); ++i) {
            CellRangeAddress merged = sheetOld.getMergedRegion(i);
            sheetNew.addMergedRegion(merged);
        }
    }

    private void transform(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, XSSFRow rowOld, HSSFRow rowNew) {
        rowNew.setHeight(rowOld.getHeight());
        for (Cell cell : rowOld) {
            HSSFCell cellNew = rowNew.createCell(cell.getColumnIndex(), cell.getCellType());
            if (cellNew == null) continue;
            this.transform(workbookOld, workbookNew, (XSSFCell)cell, cellNew);
        }
        this.lastColumn = Math.max(this.lastColumn, rowOld.getLastCellNum());
    }

    private void transform(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, XSSFCell cellOld, HSSFCell cellNew) {
        cellNew.setCellComment((Comment)cellOld.getCellComment());
        Integer hash = cellOld.getCellStyle().hashCode();
        if (this.styleMap != null && !this.styleMap.containsKey(hash)) {
            this.transform(workbookOld, workbookNew, hash, cellOld.getCellStyle(), workbookNew.createCellStyle());
        }
        cellNew.setCellStyle(this.styleMap.get(hash));
        switch (cellOld.getCellType()) {
            case BLANK: {
                break;
            }
            case BOOLEAN: {
                cellNew.setCellValue(cellOld.getBooleanCellValue());
                break;
            }
            case ERROR: {
                cellNew.setCellValue((double)cellOld.getErrorCellValue());
                break;
            }
            case FORMULA: {
                cellNew.setCellValue(cellOld.getCellFormula());
                break;
            }
            case NUMERIC: {
                cellNew.setCellValue(cellOld.getNumericCellValue());
                break;
            }
            case STRING: {
                cellNew.setCellValue(cellOld.getStringCellValue());
                break;
            }
            default: {
                System.out.println("transform: Unbekannter Zellentyp " + cellOld.getCellType());
            }
        }
    }

    private void transform(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, Integer hash, XSSFCellStyle styleOld, HSSFCellStyle styleNew) {
        styleNew.setAlignment(styleOld.getAlignment());
        styleNew.setBorderBottom(styleOld.getBorderBottom());
        styleNew.setBorderLeft(styleOld.getBorderLeft());
        styleNew.setBorderRight(styleOld.getBorderRight());
        styleNew.setBorderTop(styleOld.getBorderTop());
        styleNew.setDataFormat(this.transform(workbookOld, workbookNew, styleOld.getDataFormat()));
        styleNew.setFillBackgroundColor(styleOld.getFillBackgroundColor());
        styleNew.setFillForegroundColor(styleOld.getFillForegroundColor());
        styleNew.setFillPattern(styleOld.getFillPattern());
        styleNew.setFont(this.transform(workbookNew, styleOld.getFont()));
        styleNew.setHidden(styleOld.getHidden());
        styleNew.setIndention(styleOld.getIndention());
        styleNew.setLocked(styleOld.getLocked());
        styleNew.setVerticalAlignment(styleOld.getVerticalAlignment());
        styleNew.setWrapText(styleOld.getWrapText());
        this.styleMap.put(hash, styleNew);
    }

    private short transform(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, short index) {
        XSSFDataFormat formatOld = workbookOld.createDataFormat();
        HSSFDataFormat formatNew = workbookNew.createDataFormat();
        if (formatOld.getFormat(index) != null) {
            return formatNew.getFormat(formatOld.getFormat(index));
        }
        return index;
    }

    private HSSFFont transform(HSSFWorkbook workbookNew, XSSFFont fontOld) {
        HSSFFont fontNew = workbookNew.createFont();
        fontNew.setBold(fontOld.getBold());
        fontNew.setCharSet(fontOld.getCharSet());
        fontNew.setColor(fontOld.getColor());
        fontNew.setFontName(fontOld.getFontName());
        fontNew.setFontHeight(fontOld.getFontHeight());
        fontNew.setItalic(fontOld.getItalic());
        fontNew.setStrikeout(fontOld.getStrikeout());
        fontNew.setTypeOffset(fontOld.getTypeOffset());
        fontNew.setUnderline(fontOld.getUnderline());
        return fontNew;
    }
}

