/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service.Impl;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.search.annotation.ESType;
import com.centit.search.document.DocumentUtils;
import com.centit.search.document.ESDocument;
import com.centit.search.service.ElasticsearchClientFactory;
import com.centit.search.service.Indexer;
import java.io.Reader;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESIndexer
implements Indexer {
    private static final Logger logger = LoggerFactory.getLogger(ESIndexer.class);
    private final ElasticsearchClient client;
    private String indexName;
    private boolean sureIndexExist;
    private final Class<?> objType;

    public ESIndexer(ElasticsearchClient client, String indexName, Class<?> objType) {
        this.client = client;
        this.indexName = indexName;
        this.objType = objType;
        this.sureIndexExist = false;
    }

    public ElasticsearchClient fetchClient() {
        return this.client;
    }

    public void releaseClient() {
        ElasticsearchClientFactory.closeClient(this.client);
    }

    private void makeSureIndexIsExist() {
        if (this.sureIndexExist) {
            return;
        }
        try {
            ExistsRequest request = ExistsRequest.of(e -> e.index(this.indexName, new String[0]));
            if (!this.client.indices().exists(request).value()) {
                this.createEsIndex(this.indexName, this.objType);
            }
            this.sureIndexExist = true;
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), (Throwable)e2);
        }
    }

    private void createEsIndex(String indexName, Class<?> objType) {
        this.indexName = indexName;
        try {
            ESType esType = objType.getAnnotation(ESType.class);
            IndexSettings settings = IndexSettings.of(s -> s.numberOfShards(String.valueOf(esType.shards())).numberOfReplicas(String.valueOf(esType.replicas())));
            String mappingJson = DocumentUtils.obtainDocumentMapping(objType).toJSONString(new JSONWriter.Feature[0]);
            TypeMapping mapping = TypeMapping.of(m -> (ObjectBuilder)m.withJson((Reader)new StringReader(mappingJson)));
            CreateIndexRequest request = CreateIndexRequest.of(c -> c.index(indexName).settings(settings).mappings(mapping));
            this.client.indices().create(request);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String saveNewDocument(ESDocument document) {
        this.makeSureIndexIsExist();
        try {
            IndexRequest request = IndexRequest.of(i -> i.index(this.indexName).id(document.obtainDocumentId()).document((Object)JsonData.fromJson((String)document.toJSONObject().toJSONString(new JSONWriter.Feature[0]))));
            IndexResponse indexResponse = this.client.index(request);
            return indexResponse.id();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean deleteDocument(ESDocument document) {
        return this.deleteDocument(document.obtainDocumentId());
    }

    @Override
    public boolean deleteDocument(String docId) {
        try {
            DeleteRequest request = DeleteRequest.of(d -> d.index(this.indexName).id(docId));
            DeleteResponse response = this.client.delete(request);
            return response.result().jsonValue().equals("deleted");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public int updateDocument(ESDocument document) {
        String docId = document.obtainDocumentId();
        return this.updateDocument(docId, document);
    }

    @Override
    public int updateDocument(String docId, ESDocument document) {
        try {
            UpdateRequest request = UpdateRequest.of(u -> u.index(this.indexName).id(docId).doc((Object)JsonData.fromJson((String)document.toJSONObject().toJSONString(new JSONWriter.Feature[0]))));
            UpdateResponse response = this.client.update(request, JsonData.class);
            return response.result().jsonValue().equals("updated") ? 1 : 0;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public String mergeDocument(ESDocument document) {
        this.makeSureIndexIsExist();
        try {
            boolean exists;
            String docId = document.obtainDocumentId();
            GetRequest getRequest = GetRequest.of(g -> g.index(this.indexName).id(docId));
            try {
                GetResponse getResponse = this.client.get(getRequest, JsonData.class);
                exists = getResponse.found();
            }
            catch (Exception e) {
                exists = false;
            }
            if (exists) {
                UpdateRequest updateReq = UpdateRequest.of(u -> u.index(this.indexName).id(docId).doc((Object)JsonData.fromJson((String)document.toJSONObject().toJSONString(new JSONWriter.Feature[0]))));
                UpdateResponse response = this.client.update(updateReq, JsonData.class);
                return response.result().jsonValue().equals("updated") ? response.id() : null;
            }
            IndexRequest indexReq = IndexRequest.of(i -> i.index(this.indexName).id(docId).document((Object)JsonData.fromJson((String)document.toJSONObject().toJSONString(new JSONWriter.Feature[0]))));
            IndexResponse indexResponse = this.client.index(indexReq);
            return indexResponse.id();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

