/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.utils;

import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.JavaBeanField;
import com.centit.support.common.JavaBeanMetaData;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;

public abstract class ObjectTextExtractor {
    private static String FIELD_SPLIT_STR = ";";
    private static String ARRAY_ITEM_SPLIT_STR = ",";
    private static String KEY_VALUE_SPLIT_STR = ":";
    private static String CYCLE_REF_LABEL = "-@-";

    public static TextExtractContent createContent() {
        return new TextExtractContent();
    }

    public static String extractText(Object object, TextExtractContent content) {
        ObjectTextExtractor.innerExtractText(object, content);
        return content.textBuilder.toString();
    }

    public static String extractText(Object object, boolean omitNumber, boolean omitSymbol) {
        TextExtractContent content = ObjectTextExtractor.createContent();
        content.setOmitNumber(omitNumber);
        content.setOmitSymbol(omitSymbol);
        ObjectTextExtractor.innerExtractText(object, content);
        return content.textBuilder.toString();
    }

    public static String extractText(Object object) {
        return ObjectTextExtractor.extractText(object, false, false);
    }

    private static void innerExtractText(Object object, TextExtractContent content) {
        String[] includeFields;
        if (object == null) {
            return;
        }
        Class<?> objClazz = object.getClass();
        if (ReflectionOpt.isScalarType(objClazz)) {
            if (content.omitNumber && (object instanceof Number || object instanceof Boolean || object instanceof String && StringRegularOpt.isNumber((String)((String)object)))) {
                return;
            }
            content.textBuilder.append(object);
            return;
        }
        if (objClazz.isEnum()) {
            content.textBuilder.append(((Enum)object).name());
        }
        if (object instanceof byte[]) {
            content.textBuilder.append(new String((byte[])object));
            return;
        }
        if (content.hasExtracted(object)) {
            if (!content.omitSymbol) {
                content.textBuilder.append(CYCLE_REF_LABEL);
            }
            return;
        }
        content.addExtractedObject(object);
        if (objClazz.isArray()) {
            int len = Array.getLength(object);
            for (int i = 0; i < len; ++i) {
                if (i > 0 && !content.omitSymbol) {
                    content.textBuilder.append(ARRAY_ITEM_SPLIT_STR);
                }
                Object item = Array.get(object, i);
                ObjectTextExtractor.innerExtractText(item, content);
            }
            return;
        }
        int i = 0;
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            for (Object item : collection) {
                if (i > 0 && !content.omitSymbol) {
                    content.textBuilder.append(ARRAY_ITEM_SPLIT_STR);
                }
                ++i;
                ObjectTextExtractor.innerExtractText(item, content);
            }
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                if (i > 0 && !content.omitSymbol) {
                    content.textBuilder.append(FIELD_SPLIT_STR);
                }
                ++i;
                if (content.includeName) {
                    ObjectTextExtractor.innerExtractText(entry.getKey(), content);
                    if (!content.omitSymbol) {
                        content.textBuilder.append(KEY_VALUE_SPLIT_STR);
                    }
                }
                ObjectTextExtractor.innerExtractText(entry.getValue(), content);
            }
            return;
        }
        JavaBeanMetaData metadata = JavaBeanMetaData.createBeanMetaDataFromType(objClazz, (int)1);
        Map fileds = metadata.getFileds();
        String[] excludeFields = content.getExcludeFields(objClazz);
        if (excludeFields != null) {
            for (String skey : excludeFields) {
                fileds.remove(skey);
            }
        }
        if ((includeFields = content.getIncludeFields(objClazz)) != null) {
            for (String skey : includeFields) {
                Object item;
                JavaBeanField field = (JavaBeanField)fileds.get(skey);
                if (field == null || (item = field.getObjectFieldValue(object)) == null) continue;
                if (i > 0 && !content.omitSymbol) {
                    content.textBuilder.append(FIELD_SPLIT_STR);
                }
                ++i;
                if (content.includeName) {
                    content.textBuilder.append(skey);
                    if (!content.omitSymbol) {
                        content.textBuilder.append(KEY_VALUE_SPLIT_STR);
                    }
                }
                ObjectTextExtractor.innerExtractText(item, content);
            }
            return;
        }
        for (Map.Entry entry : fileds.entrySet()) {
            Object item = ((JavaBeanField)entry.getValue()).getObjectFieldValue(object);
            if (item == null) continue;
            if (i > 0 && !content.omitSymbol) {
                content.textBuilder.append(FIELD_SPLIT_STR);
            }
            ++i;
            if (content.includeName) {
                content.textBuilder.append((String)entry.getKey());
                if (!content.omitSymbol) {
                    content.textBuilder.append(KEY_VALUE_SPLIT_STR);
                }
            }
            ObjectTextExtractor.innerExtractText(item, content);
        }
    }

    public static class TextExtractContent {
        Map<Class<?>, String[]> includes;
        Map<Class<?>, String[]> excludes;
        boolean omitNumber = false;
        boolean omitSymbol = false;
        ArrayList<Object> hasExtracted = new ArrayList(100);
        StringBuilder textBuilder = new StringBuilder();
        boolean includeName = false;

        public TextExtractContent includePropertyName(boolean includeKey) {
            this.includeName = includeKey;
            return this;
        }

        public TextExtractContent includeProperties(Class<?> clazz, String[] properties) {
            if (this.includes == null) {
                this.includes = new HashMap(10);
            }
            this.includes.put(clazz, properties);
            return this;
        }

        public TextExtractContent excludeProperties(Class<?> clazz, String[] properties) {
            if (this.excludes == null) {
                this.excludes = new HashMap(10);
            }
            this.excludes.put(clazz, properties);
            return this;
        }

        boolean hasExtracted(Object object) {
            return this.hasExtracted.contains(object);
        }

        void addExtractedObject(Object object) {
            this.hasExtracted.add(object);
        }

        String[] getExcludeFields(Class<?> clazz) {
            if (this.excludes != null) {
                for (Map.Entry<Class<?>, String[]> clz : this.excludes.entrySet()) {
                    if (!ClassUtils.isAssignable(clazz, clz.getKey())) continue;
                    return clz.getValue();
                }
            }
            return null;
        }

        String[] getIncludeFields(Class<?> clazz) {
            if (this.includes != null) {
                for (Map.Entry<Class<?>, String[]> clz : this.includes.entrySet()) {
                    if (!ClassUtils.isAssignable(clazz, clz.getKey())) continue;
                    return clz.getValue();
                }
            }
            return null;
        }

        public void setIncludes(Map<Class<?>, String[]> includes) {
            this.includes = includes;
        }

        public void setExcludes(Map<Class<?>, String[]> excludes) {
            this.excludes = excludes;
        }

        public void setOmitNumber(boolean omitNumber) {
            this.omitNumber = omitNumber;
        }

        public void setOmitSymbol(boolean omitSymbol) {
            this.omitSymbol = omitSymbol;
        }
    }
}

