/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service.Impl;

import com.centit.search.annotation.ESField;
import com.centit.search.document.DocumentUtils;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Searcher;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.Lexer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESSearcher
implements Searcher {
    public static final String SELF_ORDER_BY = "ORDER_BY";
    public static final String SELF_ORDER_BY2 = "orderBy";
    public static final String TABLE_SORT_FIELD = "sort";
    public static final String TABLE_SORT_ORDER = "order";
    private static Logger logger = LoggerFactory.getLogger(ESSearcher.class);
    private ESServerConfig config;
    private GenericObjectPool<RestHighLevelClient> clientPool;
    private String indexName;
    private String[] highlightPreTags;
    private String[] highlightPostTags;
    private List<String> allFields;
    private String[] queryFields;
    private Set<String> highlightFields = new HashSet<String>();

    public String[] getQueryFields() {
        return this.queryFields;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ESSearcher() {
        this.highlightPreTags = new String[]{"<strong>"};
        this.highlightPostTags = new String[]{"</strong>"};
        this.allFields = new ArrayList<String>();
    }

    public ESSearcher(ESServerConfig config, GenericObjectPool<RestHighLevelClient> clientPool) {
        this();
        this.config = config;
        this.clientPool = clientPool;
    }

    public void setESServerConfig(ESServerConfig config) {
        this.config = config;
    }

    public void setClientPool(GenericObjectPool<RestHighLevelClient> clientPool) {
        this.clientPool = clientPool;
    }

    public void initTypeFields(Class<?> objType) {
        String indexName = DocumentUtils.obtainDocumentIndexName(objType);
        if (indexName != null) {
            this.initTypeFields(indexName, objType);
        }
    }

    public void initTypeFields(String indexName, Class<?> objType) {
        Field[] objFields;
        this.indexName = indexName;
        HashSet rf = new HashSet();
        HashSet<String> qf = new HashSet<String>();
        for (Field field : objFields = objType.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ESField.class)) continue;
            ESField esType = field.getAnnotation(ESField.class);
            if (esType.query()) {
                qf.add(field.getName());
            }
            if (esType.highlight()) {
                this.highlightFields.add(field.getName());
            }
            this.allFields.add(field.getName());
        }
        this.queryFields = (String[])CollectionsOpt.listToArray(qf);
    }

    public Pair<Long, List<Map<String, Object>>> esSearch(QueryBuilder queryBuilder, List<SortBuilder<?>> sortBuilders, String[] includes, String[] excludes, int pageNo, int pageSize) {
        RestHighLevelClient client = null;
        long totalHits = 0L;
        try {
            SearchRequest searchRequest;
            SearchResponse actionGet;
            SearchHits hits;
            client = (RestHighLevelClient)this.clientPool.borrowObject();
            ArrayList<HashMap<String, Float>> retList = new ArrayList<HashMap<String, Float>>(pageSize + 5);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(queryBuilder);
            searchSourceBuilder.sort((SortBuilder)SortBuilders.scoreSort());
            if (sortBuilders != null && !sortBuilders.isEmpty()) {
                searchSourceBuilder.sort(sortBuilders);
            }
            if (pageSize > 0) {
                searchSourceBuilder.explain(Boolean.valueOf(true)).from(pageNo > 1 ? (pageNo - 1) * pageSize : 0).size(pageSize);
            }
            if (!this.highlightFields.isEmpty()) {
                HighlightBuilder highlightBuilder = new HighlightBuilder();
                for (String hf : this.highlightFields) {
                    highlightBuilder.field(hf);
                }
                ((HighlightBuilder)((HighlightBuilder)((HighlightBuilder)highlightBuilder.preTags(this.highlightPreTags)).postTags(this.highlightPostTags)).fragmentSize(Integer.valueOf(200))).numOfFragments(Integer.valueOf(2));
                searchSourceBuilder.highlighter(highlightBuilder);
            }
            if (includes != null || excludes != null) {
                searchSourceBuilder.fetchSource(includes, excludes);
            }
            if ((hits = (actionGet = client.search(searchRequest = new SearchRequest(new String[]{this.indexName}).source(searchSourceBuilder), RequestOptions.DEFAULT)).getHits()) != null) {
                totalHits = hits.getTotalHits().value;
                SearchHit[] hitsRes = hits.getHits();
                if (hitsRes != null) {
                    for (SearchHit hit : hitsRes) {
                        HashMap<String, Float> json = hit.getSourceAsMap();
                        if (json == null) {
                            json = new HashMap<String, Float>(4);
                        }
                        if (hit.getHighlightFields() != null) {
                            StringBuilder content = new StringBuilder("");
                            for (Map.Entry highlight : hit.getHighlightFields().entrySet()) {
                                HighlightField highlightField = (HighlightField)highlight.getValue();
                                if (highlightField != null) {
                                    for (Text t : highlightField.fragments()) {
                                        content.append(t.string());
                                    }
                                }
                                content.append("\n");
                            }
                            json.put("highlight", (Float)((Object)content));
                        }
                        json.put("_score", Float.valueOf(hit.getScore()));
                        String hitType = hit.getType();
                        if (hitType != null) {
                            json.put("_type", (Float)((Object)hitType));
                        }
                        retList.add(json);
                    }
                }
            }
            ImmutablePair immutablePair = new ImmutablePair((Object)totalHits, retList);
            return immutablePair;
        }
        catch (Exception e) {
            throw new ObjectException(601, "\u67e5\u8be2ES\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    public Pair<Long, List<Map<String, Object>>> esSearch(QueryBuilder queryBuilder, int pageNo, int pageSize) {
        return this.esSearch(queryBuilder, null, null, null, pageNo, pageSize);
    }

    public Pair<Long, List<Map<String, Object>>> esSearch(QueryBuilder queryBuilder, List<SortBuilder<?>> sortBuilders, int pageNo, int pageSize) {
        return this.esSearch(queryBuilder, sortBuilders, null, null, pageNo, pageSize);
    }

    public static List<SortBuilder<?>> mapSortBuilder(Map<String, Object> filterMap) {
        String sortField;
        if (filterMap == null || filterMap.isEmpty()) {
            return null;
        }
        ArrayList sortBuilders = new ArrayList();
        String selfOrderBy = StringBaseOpt.objectToString((Object)filterMap.get(SELF_ORDER_BY));
        if (StringUtils.isBlank((CharSequence)selfOrderBy)) {
            selfOrderBy = StringBaseOpt.objectToString((Object)filterMap.get(SELF_ORDER_BY2));
        }
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            Lexer lexer = new Lexer(selfOrderBy, 2);
            String aWord = lexer.getAWord();
            while (StringUtils.isNotBlank((CharSequence)aWord)) {
                String field = aWord;
                SortOrder sortOrder = SortOrder.ASC;
                aWord = lexer.getAWord();
                if ("desc".equalsIgnoreCase(aWord)) {
                    sortOrder = SortOrder.DESC;
                }
                sortBuilders.add(SortBuilders.fieldSort((String)field).order(sortOrder));
                while (StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{"desc", "asc", ","})) {
                    aWord = lexer.getAWord();
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(sortField = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_FIELD))))) {
            String sOrder = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_ORDER));
            SortBuilder sortBuilder = "desc".equalsIgnoreCase(sOrder) ? SortBuilders.fieldSort((String)sortField).order(SortOrder.DESC) : SortBuilders.fieldSort((String)sortField).order(SortOrder.ASC);
            sortBuilders.add(sortBuilder);
        }
        return sortBuilders;
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> search(Map<String, Object> fieldFilter, String queryWord, int pageNo, int pageSize) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (fieldFilter != null) {
            block12: for (Map.Entry<String, Object> ent : fieldFilter.entrySet()) {
                String optSuffix;
                boolean isField = false;
                for (String fieldName : this.allFields) {
                    if (!ent.getKey().startsWith(fieldName)) continue;
                    isField = true;
                    break;
                }
                if (!isField) continue;
                if (ent.getValue().getClass().isArray()) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)ent.getKey(), (String[])((String[])ent.getValue())));
                    continue;
                }
                if (ent.getValue() instanceof Collection) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)ent.getKey(), (Object[])CollectionsOpt.listToArray((Collection)((Collection)ent.getValue()))));
                    continue;
                }
                String key = ent.getKey();
                int keyLen = key.length();
                switch (optSuffix = keyLen > 3 ? key.substring(keyLen - 3).toLowerCase() : "_eq") {
                    case "_gt": {
                        queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)key.substring(0, keyLen - 3)).gt(ent.getValue()));
                        continue block12;
                    }
                    case "_ge": {
                        queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)key.substring(0, keyLen - 3)).gte(ent.getValue()));
                        continue block12;
                    }
                    case "_lt": {
                        queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)key.substring(0, keyLen - 3)).lt(ent.getValue()));
                        continue block12;
                    }
                    case "_le": {
                        queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)key.substring(0, keyLen - 3)).lte(ent.getValue()));
                        continue block12;
                    }
                }
                queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)ent.getKey(), (Object)ent.getValue()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)queryWord)) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.multiMatchQuery((Object)queryWord, (String[])this.queryFields));
        }
        return this.esSearch((QueryBuilder)queryBuilder, ESSearcher.mapSortBuilder(fieldFilter), pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> search(String queryWord, int pageNo, int pageSize) {
        return this.search(null, queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOpt(String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOwner(String owner, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", owner}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOwner(String owner, String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", owner, "optId", optId}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchUnits(String[] units, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", units}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchUnits(String[] units, String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId, "unitCode", units}), queryWord, pageNo, pageSize);
    }

    public ESSearcher setHighlightPreTags(String[] highlightPreTags) {
        this.highlightPreTags = highlightPreTags;
        return this;
    }

    public ESSearcher setHighlightPostTags(String[] highlightPostTags) {
        this.highlightPostTags = highlightPostTags;
        return this;
    }
}

