/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.utils;

import com.alibaba.fastjson2.JSONObject;
import com.centit.search.utils.ObjectTextExtractor;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.image.ImageOpt;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import com.centit.support.security.SecurityOptUtils;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

public abstract class ImagePdfTextExtractor {
    public static List<BufferedImage> fetchPdfImages(InputStream inputStream) throws IOException, DocumentException {
        PdfReader pdf = new PdfReader(inputStream);
        int pageSum = pdf.getNumberOfPages();
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(pageSum + 5);
        for (int p = 0; p < pageSum; ++p) {
            PdfDictionary pg = pdf.getPageN(p + 1);
            PdfDictionary res = (PdfDictionary)PdfReader.getPdfObject((PdfObject)pg.get(PdfName.RESOURCES));
            PdfDictionary xobj = (PdfDictionary)PdfReader.getPdfObject((PdfObject)res.get(PdfName.XOBJECT));
            if (xobj == null) continue;
            for (PdfName pdfName : xobj.getKeys()) {
                BufferedImage image;
                int XrefIndex;
                PdfObject pdfObj;
                PdfStream pdfStrem;
                byte[] bytes;
                PdfDictionary tg;
                PdfName type;
                PdfObject obj = xobj.get(pdfName);
                if (!obj.isIndirect() || !PdfName.IMAGE.equals((Object)(type = (PdfName)PdfReader.getPdfObject((PdfObject)(tg = (PdfDictionary)PdfReader.getPdfObject((PdfObject)obj)).get(PdfName.SUBTYPE)))) || (bytes = PdfReader.getStreamBytesRaw((PRStream)((PRStream)(pdfStrem = (PdfStream)(pdfObj = pdf.getPdfObject(XrefIndex = ((PRIndirectReference)obj).getNumber())))))) == null || (image = ImageIO.read(new ByteArrayInputStream(bytes))) == null) continue;
                images.add(image);
            }
        }
        return images;
    }

    public static OcrServerHost fetchDefaultOrrServer() {
        OcrServerHost ocrServer = new OcrServerHost();
        ocrServer.setAuthorUrl("http://192.168.133.61:8080/token");
        ocrServer.setOrcUrl("http://192.168.133.61:8080/file-upload/ocr");
        ocrServer.setUserName("cipher:yKxmpDSt7xoAdTs1onNgjQ==");
        ocrServer.setPassword("cipher:Eo/8Mu1xoKe6fBkfA8OMdQ==");
        return ocrServer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String imagesToText(List<InputStream> imageFile, OcrServerHost ocrServer) {
        try (CloseableHttpClient client = HttpExecutor.createHttpClient();){
            HttpExecutorContext executorContext = HttpExecutorContext.create((CloseableHttpClient)client);
            String response = HttpExecutor.formPost((HttpExecutorContext)executorContext, (String)ocrServer.getAuthorUrl(), (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"grant_type", "password", "username", SecurityOptUtils.decodeSecurityString((String)ocrServer.getUserName()), "password", SecurityOptUtils.decodeSecurityString((String)ocrServer.getPassword())}));
            JSONObject jsonObject = JSONObject.parseObject((String)response);
            executorContext.header("Authorization", "Bearer " + jsonObject.getString("access_token"));
            HttpPost httpPost = new HttpPost(ocrServer.getOrcUrl());
            httpPost.setHeader("Content-Type", "multipart/form-data; charset=UTF-8; boundary=------1cC9oE7dN8eT1fI0aT2n4------");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setBoundary("------1cC9oE7dN8eT1fI0aT2n4------");
            int n = 0;
            for (InputStream image : imageFile) {
                builder.addBinaryBody("files", image, ContentType.IMAGE_JPEG, "image" + n + ".jpg");
                ++n;
            }
            httpPost.setEntity(builder.build());
            response = HttpExecutor.httpExecute((HttpExecutorContext)executorContext, (HttpRequestBase)httpPost);
            JSONObject jsonObject1 = JSONObject.parseObject((String)response);
            String string = response = ObjectTextExtractor.extractText(jsonObject1.get("documents"), true, true);
            return string;
        }
        catch (IOException e) {
            throw new ObjectException((Throwable)e);
        }
    }

    public static String imagePdfToText(InputStream pdfFile, OcrServerHost ocrServer) {
        try {
            List<BufferedImage> images = ImagePdfTextExtractor.fetchPdfImages(pdfFile);
            ArrayList<InputStream> imagesFile = new ArrayList<InputStream>();
            for (BufferedImage image : images) {
                imagesFile.add(ImageOpt.imageToInputStream((BufferedImage)image));
            }
            return ImagePdfTextExtractor.imagesToText(imagesFile, ocrServer);
        }
        catch (DocumentException | IOException e) {
            throw new ObjectException(e);
        }
    }

    public static String imageToText(InputStream imageFile, OcrServerHost ocrServer) {
        return ImagePdfTextExtractor.imagesToText(CollectionsOpt.createList((Object[])new InputStream[]{imageFile}), ocrServer);
    }

    public static class OcrServerHost {
        String authorUrl;
        String orcUrl;
        String userName;
        String password;

        public String getAuthorUrl() {
            return this.authorUrl;
        }

        public String getOrcUrl() {
            return this.orcUrl;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setAuthorUrl(String authorUrl) {
            this.authorUrl = authorUrl;
        }

        public void setOrcUrl(String orcUrl) {
            this.orcUrl = orcUrl;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OcrServerHost)) {
                return false;
            }
            OcrServerHost other = (OcrServerHost)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$authorUrl = this.getAuthorUrl();
            String other$authorUrl = other.getAuthorUrl();
            if (this$authorUrl == null ? other$authorUrl != null : !this$authorUrl.equals(other$authorUrl)) {
                return false;
            }
            String this$orcUrl = this.getOrcUrl();
            String other$orcUrl = other.getOrcUrl();
            if (this$orcUrl == null ? other$orcUrl != null : !this$orcUrl.equals(other$orcUrl)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OcrServerHost;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $authorUrl = this.getAuthorUrl();
            result = result * 59 + ($authorUrl == null ? 43 : $authorUrl.hashCode());
            String $orcUrl = this.getOrcUrl();
            result = result * 59 + ($orcUrl == null ? 43 : $orcUrl.hashCode());
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "ImagePdfTextExtractor.OcrServerHost(authorUrl=" + this.getAuthorUrl() + ", orcUrl=" + this.getOrcUrl() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ")";
        }
    }
}

