/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.document;

import com.alibaba.fastjson2.JSONObject;
import com.centit.search.annotation.ESField;
import com.centit.search.annotation.ESType;
import com.centit.support.algorithm.CollectionsOpt;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;

public abstract class DocumentUtils {
    public static String obtainDocumentIndexName(Class<?> objType) {
        if (objType.isAnnotationPresent(ESType.class)) {
            ESType et = objType.getAnnotation(ESType.class);
            return et.indexName();
        }
        return null;
    }

    public static JSONObject obtainDocumentMapping(Class<?> objType) {
        Field[] objFields = objType.getDeclaredFields();
        JSONObject fieldsMap = new JSONObject();
        for (Field field : objFields) {
            if (!field.isAnnotationPresent(ESField.class)) continue;
            ESField esType = field.getAnnotation(ESField.class);
            JSONObject fieldConfig = new JSONObject(CollectionsOpt.createHashMap((Object[])new Object[]{"type", StringUtils.isBlank((CharSequence)esType.type()) ? field.getType().getSimpleName() : esType.type(), "index", esType.index(), "store", esType.store()}));
            if (esType.query()) {
                if (StringUtils.isNotBlank((CharSequence)esType.analyzer())) {
                    fieldConfig.put((Object)"analyzer", (Object)esType.analyzer());
                } else {
                    fieldConfig.put((Object)"analyzer", (Object)"standard");
                }
                if (StringUtils.isNotBlank((CharSequence)esType.indexAnalyzer())) {
                    fieldConfig.put((Object)"index_analyzer", (Object)esType.indexAnalyzer());
                }
                if (StringUtils.isNotBlank((CharSequence)esType.searchAnalyzer())) {
                    fieldConfig.put((Object)"search_analyzer", (Object)esType.searchAnalyzer());
                }
            }
            fieldsMap.put((Object)field.getName(), (Object)fieldConfig);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"properties", (Object)fieldsMap);
        return jsonObject;
    }
}

