/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service.Impl;

import com.centit.search.service.ESServerConfig;
import com.centit.support.security.SecurityOptUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class PooledRestClientFactory
implements PooledObjectFactory<RestHighLevelClient> {
    private ESServerConfig config;

    public PooledRestClientFactory(ESServerConfig config) {
        this.config = config;
    }

    public PooledObject<RestHighLevelClient> makeObject() throws Exception {
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])this.config.getHttpHosts());
        if (StringUtils.isNotBlank((CharSequence)this.config.getUsername()) && StringUtils.isNotBlank((CharSequence)this.config.getPassword())) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.config.getUsername(), SecurityOptUtils.decodeSecurityString((String)this.config.getPassword())));
            clientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
                httpClientBuilder.disableAuthCaching();
                return httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            });
        }
        RestHighLevelClient client = new RestHighLevelClient(clientBuilder);
        return new DefaultPooledObject((Object)client);
    }

    public void destroyObject(PooledObject<RestHighLevelClient> p) throws Exception {
        RestHighLevelClient client = (RestHighLevelClient)p.getObject();
        if (client != null && client.ping(RequestOptions.DEFAULT)) {
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean validateObject(PooledObject<RestHighLevelClient> p) {
        RestHighLevelClient client = (RestHighLevelClient)p.getObject();
        try {
            return client.ping(RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void activateObject(PooledObject<RestHighLevelClient> p) throws Exception {
        RestHighLevelClient client = (RestHighLevelClient)p.getObject();
        client.ping(RequestOptions.DEFAULT);
    }

    public void passivateObject(PooledObject<RestHighLevelClient> p) throws Exception {
    }

    public void setConifg(ESServerConfig conifg) {
        this.config = conifg;
    }
}

