/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service.Impl;

import com.centit.search.annotation.ESField;
import com.centit.search.document.DocumentUtils;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Searcher;
import com.centit.support.algorithm.CollectionsOpt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESSearcher
implements Searcher {
    private static final String KEYWORD = ".keyword";
    private static Logger logger = LoggerFactory.getLogger(ESSearcher.class);
    private ESServerConfig config;
    private GenericObjectPool<RestHighLevelClient> clientPool;
    private String indexName;
    private String[] highlightPreTags;
    private String[] highlightPostTags;
    private String[] queryFields;
    private Set<String> highlightFields = new HashSet<String>();

    public String[] getQueryFields() {
        return this.queryFields;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ESSearcher() {
        this.highlightPreTags = new String[]{"<strong>"};
        this.highlightPostTags = new String[]{"</strong>"};
    }

    public ESSearcher(ESServerConfig config, GenericObjectPool<RestHighLevelClient> clientPool) {
        this();
        this.config = config;
        this.clientPool = clientPool;
    }

    public void setESServerConfig(ESServerConfig config) {
        this.config = config;
    }

    public void setClientPool(GenericObjectPool<RestHighLevelClient> clientPool) {
        this.clientPool = clientPool;
    }

    public void initTypeFields(Class<?> objType) {
        String indexName = DocumentUtils.obtainDocumentIndexName(objType);
        if (indexName != null) {
            this.initTypeFields(indexName, objType);
        }
    }

    public void initTypeFields(String indexName, Class<?> objType) {
        Field[] objFields;
        this.indexName = indexName;
        HashSet rf = new HashSet();
        HashSet<String> qf = new HashSet<String>();
        for (Field field : objFields = objType.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ESField.class)) continue;
            ESField esType = field.getAnnotation(ESField.class);
            if (esType.query()) {
                qf.add(field.getName());
            }
            if (!esType.highlight()) continue;
            this.highlightFields.add(field.getName());
        }
        this.queryFields = (String[])CollectionsOpt.listToArray(qf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Long, List<Map<String, Object>>> esSearch(QueryBuilder queryBuilder, String[] includes, String[] excludes, int pageNo, int pageSize) {
        RestHighLevelClient client = null;
        long totalHits = 0L;
        try {
            SearchRequest searchRequest;
            SearchResponse actionGet;
            SearchHits hits;
            client = (RestHighLevelClient)this.clientPool.borrowObject();
            ArrayList<HashMap<String, Float>> retList = new ArrayList<HashMap<String, Float>>(pageSize + 5);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(queryBuilder).explain(Boolean.valueOf(true)).from(pageNo > 1 ? (pageNo - 1) * pageSize : 0).size(pageSize);
            if (this.highlightFields.size() > 0) {
                HighlightBuilder highlightBuilder = new HighlightBuilder();
                for (String hf : this.highlightFields) {
                    highlightBuilder.field(hf);
                }
                ((HighlightBuilder)((HighlightBuilder)((HighlightBuilder)highlightBuilder.preTags(this.highlightPreTags)).postTags(this.highlightPostTags)).fragmentSize(Integer.valueOf(200))).numOfFragments(Integer.valueOf(2));
                searchSourceBuilder.highlighter(highlightBuilder);
            }
            if (includes != null || excludes != null) {
                searchSourceBuilder.fetchSource(includes, excludes);
            }
            if ((hits = (actionGet = client.search(searchRequest = new SearchRequest(new String[]{this.indexName}).source(searchSourceBuilder), RequestOptions.DEFAULT)).getHits()) != null) {
                totalHits = hits.getTotalHits().value;
                SearchHit[] hitsRes = hits.getHits();
                if (hitsRes != null) {
                    for (SearchHit hit : hitsRes) {
                        HashMap<String, Float> json = hit.getSourceAsMap();
                        if (json == null) {
                            json = new HashMap<String, Float>(4);
                        }
                        if (hit.getHighlightFields() != null) {
                            StringBuilder content = new StringBuilder("");
                            for (Map.Entry highlight : hit.getHighlightFields().entrySet()) {
                                HighlightField highlightField = (HighlightField)highlight.getValue();
                                if (highlightField != null) {
                                    for (Text t : highlightField.fragments()) {
                                        content.append(t.string());
                                    }
                                }
                                content.append("\n");
                            }
                            json.put("highlight", (Float)((Object)content));
                        }
                        json.put("_score", Float.valueOf(hit.getScore()));
                        String hitType = hit.getType();
                        if (hitType != null) {
                            json.put("_type", (Float)((Object)hitType));
                        }
                        retList.add(json);
                    }
                }
            }
            ImmutablePair immutablePair = new ImmutablePair((Object)totalHits, retList);
            return immutablePair;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Pair<Long, List<Map<String, Object>>> pair = null;
            return pair;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    public Pair<Long, List<Map<String, Object>>> esSearch(QueryBuilder queryBuilder, int pageNo, int pageSize) {
        return this.esSearch(queryBuilder, null, null, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> search(Map<String, Object> fieldFilter, String queryWord, int pageNo, int pageSize) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (fieldFilter != null) {
            for (Map.Entry<String, Object> ent : fieldFilter.entrySet()) {
                if (ent.getValue().getClass().isArray()) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)(ent.getKey() + KEYWORD), (String[])((String[])ent.getValue())));
                    continue;
                }
                if (ent.getValue() instanceof Collection) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)(ent.getKey() + KEYWORD), (Object[])CollectionsOpt.listToArray((Collection)((Collection)ent.getValue()))));
                    continue;
                }
                queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)(ent.getKey() + KEYWORD), (Object)ent.getValue()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)queryWord)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)queryWord, (String[])this.queryFields));
        }
        return this.esSearch((QueryBuilder)queryBuilder, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> search(String queryWord, int pageNo, int pageSize) {
        return this.search(null, queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOpt(String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOwner(String owner, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", owner}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOwner(String owner, String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", owner, "optId", optId}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchUnits(String[] units, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", units}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchUnits(String[] units, String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId, "unitCode", units}), queryWord, pageNo, pageSize);
    }

    public ESSearcher setHighlightPreTags(String[] highlightPreTags) {
        this.highlightPreTags = highlightPreTags;
        return this;
    }

    public ESSearcher setHighlightPostTags(String[] highlightPostTags) {
        this.highlightPostTags = highlightPostTags;
        return this;
    }
}

