/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service.Impl;

import com.centit.search.annotation.ESField;
import com.centit.search.document.DocumentUtils;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Searcher;
import com.centit.support.algorithm.CollectionsOpt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESSearcher
implements Searcher {
    private static Logger logger = LoggerFactory.getLogger(ESSearcher.class);
    private ESServerConfig config;
    private GenericObjectPool<RestHighLevelClient> clientPool;
    private String indexName;
    private String[] hightPreTags;
    private String[] hightPostTags;
    private String[] queryFields;
    private Set<String> highlightFields = new HashSet<String>();
    private String[] revertFields;

    public ESSearcher() {
    }

    public ESSearcher(ESServerConfig config, GenericObjectPool<RestHighLevelClient> clientPool) {
        this.config = config;
        this.clientPool = clientPool;
    }

    public void setESServerConfig(ESServerConfig config) {
        this.config = config;
    }

    public void setClientPool(GenericObjectPool<RestHighLevelClient> clientPool) {
        this.clientPool = clientPool;
    }

    public void initTypeFields(Class<?> objType) {
        String indexName = DocumentUtils.obtainDocumentIndexName(objType);
        if (indexName != null) {
            this.initTypeFields(indexName, objType);
        }
    }

    public void initTypeFields(String indexName, Class<?> objType) {
        Field[] objFields;
        this.indexName = indexName;
        HashSet<String> rf = new HashSet<String>();
        HashSet<String> qf = new HashSet<String>();
        for (Field field : objFields = objType.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ESField.class)) continue;
            ESField esType = field.getAnnotation(ESField.class);
            if (esType.query()) {
                qf.add(field.getName());
            }
            if (esType.highlight()) {
                this.highlightFields.add(field.getName());
            }
            if (!esType.revert()) continue;
            rf.add(field.getName());
        }
        this.revertFields = (String[])CollectionsOpt.listToArray(rf);
        this.queryFields = (String[])CollectionsOpt.listToArray(qf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Long, List<Map<String, Object>>> esSearch(QueryBuilder queryBuilder, int pageNo, int pageSize) {
        RestHighLevelClient client = null;
        long totalHits = 0L;
        try {
            client = (RestHighLevelClient)this.clientPool.borrowObject();
            ArrayList<HashMap<String, Float>> retList = new ArrayList<HashMap<String, Float>>(pageSize + 5);
            HighlightBuilder highlightBuilder = new HighlightBuilder();
            for (String hf : this.highlightFields) {
                highlightBuilder.field(hf);
            }
            ((HighlightBuilder)highlightBuilder.preTags(this.hightPreTags)).postTags(this.hightPostTags);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query(queryBuilder);
            searchSourceBuilder.highlighter(highlightBuilder);
            searchSourceBuilder.explain(Boolean.valueOf(true));
            searchSourceBuilder.from(pageNo > 1 ? (pageNo - 1) * pageSize : 0);
            searchSourceBuilder.size(pageSize);
            SearchRequest searchRequest = new SearchRequest(new String[]{this.indexName});
            searchRequest.source(searchSourceBuilder);
            SearchResponse actionGet = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = actionGet.getHits();
            if (hits != null) {
                totalHits = hits.getTotalHits().value;
            }
            for (SearchHit hit : hits.getHits()) {
                HashMap<String, Float> json = hit.getSourceAsMap();
                if (json == null) {
                    json = new HashMap<String, Float>(4);
                }
                if (hit.getHighlightFields() != null) {
                    StringBuilder content = new StringBuilder("");
                    for (Map.Entry highlight : hit.getHighlightFields().entrySet()) {
                        HighlightField highlightField = (HighlightField)highlight.getValue();
                        if (highlightField != null) {
                            for (Text t : highlightField.fragments()) {
                                content.append(t.string());
                            }
                        }
                        content.append("\n");
                    }
                    json.put("highlight", (Float)((Object)content));
                }
                json.put("_score", Float.valueOf(hit.getScore()));
                String hitType = hit.getType();
                if (hitType != null) {
                    json.put("_type", (Float)((Object)hitType));
                }
                retList.add(json);
            }
            ImmutablePair immutablePair = new ImmutablePair((Object)totalHits, retList);
            return immutablePair;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Pair<Long, List<Map<String, Object>>> pair = null;
            return pair;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> search(Map<String, Object> fieldFilter, String queryWord, int pageNo, int pageSize) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (fieldFilter != null) {
            for (Map.Entry<String, Object> ent : fieldFilter.entrySet()) {
                if (ent.getValue().getClass().isArray()) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)ent.getKey(), (String[])((String[])ent.getValue())));
                    continue;
                }
                if (ent.getValue() instanceof Collection) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)ent.getKey(), (Object[])CollectionsOpt.listToArray((Collection)((Collection)ent.getValue()))));
                    continue;
                }
                queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)ent.getKey(), (Object)ent.getValue()));
            }
        }
        if (!"".equals(queryWord)) {
            queryBuilder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)queryWord, (String[])this.queryFields));
        }
        return this.esSearch((QueryBuilder)queryBuilder, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> search(String queryWord, int pageNo, int pageSize) {
        return this.search(null, queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOpt(String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOwner(String owner, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", owner}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchOwner(String owner, String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", owner, "optId", optId}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchUnits(String[] units, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", units}), queryWord, pageNo, pageSize);
    }

    @Override
    public Pair<Long, List<Map<String, Object>>> searchUnits(String[] units, String optId, String queryWord, int pageNo, int pageSize) {
        return this.search(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId, "unitCode", units}), queryWord, pageNo, pageSize);
    }

    public ESSearcher setHightPreTags(String[] hightPreTags) {
        this.hightPreTags = hightPreTags;
        return this;
    }

    public ESSearcher setHightPostTags(String[] hightPostTags) {
        this.hightPostTags = hightPostTags;
        return this;
    }
}

