/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.document;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.search.annotation.ESField;
import com.centit.search.annotation.ESType;
import com.centit.search.document.ESDocument;
import com.centit.search.utils.ObjectTextExtractor;
import com.centit.support.security.Md5Encoder;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@ESType(indexName="objects", replicas=2, shards=5)
public class ObjectDocument
implements ESDocument,
Serializable {
    private static final long serialVersionUID = 1L;
    @ESField(type="text")
    private String osId;
    @ESField(type="text")
    private String optId;
    @ESField(type="text")
    private String optMethod;
    @ESField(type="text")
    private String optTag;
    @ESField(type="text")
    private String optUrl;
    @ESField(type="text")
    private String userCode;
    @ESField(type="text")
    private String unitCode;
    @ESField(type="text", index=true, analyzer="ik_smart", query=true)
    private String title;
    @ESField(type="text", index=true, query=true, revert=false, highlight=true, analyzer="ik_smart")
    private String content;
    @ESField(type="date")
    private Date createTime;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectDocument)) {
            return false;
        }
        ObjectDocument that = (ObjectDocument)o;
        if (!this.getOsId().equals(that.getOsId())) {
            return false;
        }
        if (!this.getOptId().equals(that.getOptId())) {
            return false;
        }
        return this.getOptTag().equals(that.getOptTag()) && (this.getOptMethod() != null ? this.getOptMethod().equals(that.getOptMethod()) : that.getOptMethod() == null);
    }

    public int hashCode() {
        return this.obtainDocumentId().hashCode();
    }

    public String toString() {
        return this.toJsonString();
    }

    public String toJsonString() {
        return JSON.toJSONString((Object)this);
    }

    @Override
    public String obtainDocumentId() {
        String objectId = this.osId + ":" + this.optId + ":" + this.optTag;
        if (StringUtils.length((CharSequence)objectId) > 36) {
            objectId = this.optId + ":" + Md5Encoder.encode((String)objectId);
        }
        return objectId;
    }

    @Override
    public JSONObject toJSONObject() {
        return (JSONObject)JSON.toJSON((Object)this);
    }

    public ObjectDocument contentObject(Object obj) {
        this.content = ObjectTextExtractor.extractText(obj);
        return this;
    }

    public String getOsId() {
        return this.osId;
    }

    public String getOptId() {
        return this.optId;
    }

    public String getOptMethod() {
        return this.optMethod;
    }

    public String getOptTag() {
        return this.optTag;
    }

    public String getOptUrl() {
        return this.optUrl;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public void setOptId(String optId) {
        this.optId = optId;
    }

    public void setOptMethod(String optMethod) {
        this.optMethod = optMethod;
    }

    public void setOptTag(String optTag) {
        this.optTag = optTag;
    }

    public void setOptUrl(String optUrl) {
        this.optUrl = optUrl;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}

