/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.document;

import com.alibaba.fastjson.JSONObject;
import com.centit.search.annotation.ESField;
import com.centit.search.annotation.ESType;
import com.centit.support.algorithm.CollectionsOpt;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class DocumentUtils {
    public static String obtainDocumentIndexName(Class<?> objType) {
        if (objType.isAnnotationPresent(ESType.class)) {
            ESType et = objType.getAnnotation(ESType.class);
            return et.indexName();
        }
        return null;
    }

    public static JSONObject obtainDocumentMapping(Class<?> objType) {
        Field[] objFields = objType.getDeclaredFields();
        JSONObject fieldsMap = new JSONObject();
        for (Field field : objFields) {
            if (!field.isAnnotationPresent(ESField.class)) continue;
            ESField esType = field.getAnnotation(ESField.class);
            Map fieldConfig = CollectionsOpt.createHashMap((Object[])new Object[]{"type", StringUtils.isBlank((CharSequence)esType.type()) ? field.getType().getSimpleName() : esType.type(), "index", esType.index(), "store", esType.store()});
            if (StringUtils.isNotBlank((CharSequence)esType.analyzer())) {
                fieldConfig.put("analyzer", esType.analyzer());
            }
            if (StringUtils.isNotBlank((CharSequence)esType.indexAnalyzer())) {
                fieldConfig.put("indexAnalyzer", esType.indexAnalyzer());
            }
            if (StringUtils.isNotBlank((CharSequence)esType.searchAnalyzer())) {
                fieldConfig.put("searchAnalyzer", esType.searchAnalyzer());
            }
            fieldsMap.put(field.getName(), (Object)fieldConfig);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("properties", (Object)fieldsMap);
        return jsonObject;
    }
}

