/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service.Impl;

import com.centit.search.service.ESServerConfig;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class PooledRestClientFactory
implements PooledObjectFactory<RestHighLevelClient> {
    private ESServerConfig config;

    public PooledRestClientFactory(ESServerConfig config) {
        this.config = config;
    }

    public PooledObject<RestHighLevelClient> makeObject() throws Exception {
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])this.config.getHttpHosts());
        RestHighLevelClient client = new RestHighLevelClient(clientBuilder);
        return new DefaultPooledObject((Object)client);
    }

    public void destroyObject(PooledObject<RestHighLevelClient> p) throws Exception {
        RestHighLevelClient client = (RestHighLevelClient)p.getObject();
        if (client != null && client.ping(RequestOptions.DEFAULT)) {
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean validateObject(PooledObject<RestHighLevelClient> p) {
        RestHighLevelClient client = (RestHighLevelClient)p.getObject();
        try {
            return client.ping(RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void activateObject(PooledObject<RestHighLevelClient> p) throws Exception {
        RestHighLevelClient client = (RestHighLevelClient)p.getObject();
        boolean response = client.ping(RequestOptions.DEFAULT);
    }

    public void passivateObject(PooledObject<RestHighLevelClient> p) throws Exception {
    }

    public void setConifg(ESServerConfig conifg) {
        this.config = conifg;
    }
}

