/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service.Impl;

import com.centit.search.annotation.ESType;
import com.centit.search.document.DocumentUtils;
import com.centit.search.document.ESDocument;
import com.centit.search.service.Indexer;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESIndexer
implements Indexer {
    private static Logger logger = LoggerFactory.getLogger(ESIndexer.class);
    private GenericObjectPool<RestHighLevelClient> clientPool;
    private String indexName;

    public ESIndexer() {
    }

    public ESIndexer(GenericObjectPool<RestHighLevelClient> clientPool, String indexName) {
        this.clientPool = clientPool;
        this.indexName = indexName;
    }

    public void setClientPool(GenericObjectPool<RestHighLevelClient> clientPool) {
        this.clientPool = clientPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndexIfNotExist(String indexName, Class<?> objType) {
        RestHighLevelClient client = null;
        try {
            client = (RestHighLevelClient)this.clientPool.borrowObject();
            GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
            if (!client.indices().exists(request, RequestOptions.DEFAULT)) {
                this.createEsIndex(indexName, objType);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEsIndex(String indexName, Class<?> objType) {
        this.indexName = indexName;
        RestHighLevelClient client = null;
        try {
            client = (RestHighLevelClient)this.clientPool.borrowObject();
            CreateIndexRequest request = new CreateIndexRequest(indexName);
            ESType esType = objType.getAnnotation(ESType.class);
            request.settings(Settings.builder().put("index.number_of_shards", esType.shards()).put("index.number_of_replicas", esType.replicas()));
            request.mapping(DocumentUtils.obtainDocumentMapping(objType).toJSONString(), XContentType.JSON);
            client.indices().create(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveNewDocument(ESDocument document) {
        RestHighLevelClient client = null;
        try {
            client = (RestHighLevelClient)this.clientPool.borrowObject();
            IndexRequest request = new IndexRequest(this.indexName).id(document.obtainDocumentId()).source((Map)document.toJSONObject());
            IndexResponse indexResponse = client.index(request, RequestOptions.DEFAULT);
            String string = indexResponse.getId();
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDocument(ESDocument document) {
        RestHighLevelClient client = null;
        try {
            client = (RestHighLevelClient)this.clientPool.borrowObject();
            String docId = document.obtainDocumentId();
            DeleteRequest request = ((DeleteRequest)new DeleteRequest().index(this.indexName)).id(docId);
            DeleteResponse response = client.delete(request, RequestOptions.DEFAULT);
            boolean bl = response.status().getStatus() == 200;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDocument(String docType, String docId) {
        RestHighLevelClient client = null;
        try {
            client = (RestHighLevelClient)this.clientPool.borrowObject();
            DeleteRequest request = new DeleteRequest(this.indexName, docType, docId);
            DeleteResponse response = client.delete(request, RequestOptions.DEFAULT);
            boolean bl = response.status().getStatus() == 200;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    @Override
    public int updateDocument(ESDocument document) {
        String docId = document.obtainDocumentId();
        return this.updateDocument(docId, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateDocument(String docId, ESDocument document) {
        RestHighLevelClient client = null;
        try {
            client = (RestHighLevelClient)this.clientPool.borrowObject();
            UpdateRequest request = ((UpdateRequest)new UpdateRequest().index(this.indexName)).id(docId).doc((Map)document.toJSONObject());
            UpdateResponse response = client.update(request, RequestOptions.DEFAULT);
            int ret = response.status().getStatus();
            int n = ret == 200 ? 1 : 0;
            return n;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String mergeDocument(ESDocument document) {
        RestHighLevelClient client = null;
        try {
            client = (RestHighLevelClient)this.clientPool.borrowObject();
            String docId = document.obtainDocumentId();
            GetIndexRequest request = new GetIndexRequest(new String[]{this.indexName});
            if (client.indices().exists(request, RequestOptions.DEFAULT)) {
                UpdateRequest req = ((UpdateRequest)new UpdateRequest().index(this.indexName)).id(docId).doc((Map)document.toJSONObject());
                UpdateResponse response = client.update(req, RequestOptions.DEFAULT);
                int ret = response.status().getStatus();
                String string = ret == 200 ? response.getId() : null;
                return string;
            }
            IndexRequest req = new IndexRequest(this.indexName).id(docId).source((Map)document.toJSONObject());
            IndexResponse indexResponse = client.index(req, RequestOptions.DEFAULT);
            String string = indexResponse.getId();
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (client != null) {
                this.clientPool.returnObject((Object)client);
            }
        }
    }
}

