/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.orm;

import com.centit.support.common.LeftRightPair;
import com.centit.support.common.ObjectException;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TableMapInfo
extends SimpleTableInfo {
    private boolean embeddedId = false;
    private SimpleTableField embeddedIdField;
    private List<LeftRightPair<String, ValueGenerator>> valueGenerators;

    public List<LeftRightPair<String, ValueGenerator>> getValueGenerators() {
        return this.valueGenerators;
    }

    public TableMapInfo addValueGenerator(String fieldName, ValueGenerator generator) {
        if (this.valueGenerators == null) {
            this.valueGenerators = new ArrayList<LeftRightPair<String, ValueGenerator>>(5);
        }
        this.valueGenerators.add((LeftRightPair<String, ValueGenerator>)new LeftRightPair((Object)fieldName, (Object)generator));
        return this;
    }

    public boolean hasGeneratedKeys() {
        if (this.valueGenerators == null) {
            return false;
        }
        for (LeftRightPair<String, ValueGenerator> ent : this.valueGenerators) {
            ValueGenerator valueGenerator = (ValueGenerator)ent.getRight();
            if (!GeneratorType.AUTO.equals((Object)valueGenerator.strategy())) continue;
            return true;
        }
        return false;
    }

    public SimpleTableField fetchGeneratedKey() {
        if (this.valueGenerators == null) {
            return null;
        }
        for (LeftRightPair<String, ValueGenerator> ent : this.valueGenerators) {
            ValueGenerator valueGenerator = (ValueGenerator)ent.getRight();
            if (!GeneratorType.AUTO.equals((Object)valueGenerator.strategy())) continue;
            return this.findFieldByName((String)ent.getLeft());
        }
        return null;
    }

    public void appendOrderBy(SimpleTableField column, String orderBy) {
        String orderBySql = StringUtils.isBlank((CharSequence)orderBy) || "ASC".equalsIgnoreCase(orderBy) ? column.getColumnName() : ("DESC".equalsIgnoreCase(orderBy) ? column.getColumnName() + " DESC" : orderBy);
        if (StringUtils.isBlank((CharSequence)super.getOrderBy())) {
            super.setOrderBy(orderBySql);
        } else {
            super.setOrderBy(super.getOrderBy() + ", " + orderBySql);
        }
    }

    public boolean isEmbeddedId() {
        return this.embeddedId;
    }

    public void setEmbeddedId(boolean embeddedId) {
        this.embeddedId = embeddedId;
    }

    public SimpleTableField getEmbeddedIdField() {
        return this.embeddedIdField;
    }

    public void setEmbeddedIdField(SimpleTableField embeddedIdField) {
        this.embeddedIdField = embeddedIdField;
    }

    public Object getObjectFieldValue(Object object, SimpleTableField field) {
        if (field.isPrimaryKey() && this.isEmbeddedId()) {
            Object pkId = this.embeddedIdField.getBeanField().getObjectFieldValue(object);
            if (pkId != null) {
                return field.getBeanField().getObjectFieldValue(pkId);
            }
            return null;
        }
        return field.getBeanField().getObjectFieldValue(object);
    }

    public void setObjectFieldValue(Object object, SimpleTableField field, Object newValue) {
        try {
            if (field.isPrimaryKey() && this.isEmbeddedId()) {
                Object pkId = this.embeddedIdField.getBeanField().getObjectFieldValue(object);
                if (pkId == null) {
                    pkId = this.embeddedIdField.getJavaType().newInstance();
                    field.getBeanField().setObjectFieldValue(pkId, newValue);
                    this.embeddedIdField.getBeanField().setObjectFieldValue(object, pkId);
                } else {
                    field.getBeanField().setObjectFieldValue(pkId, newValue);
                }
            } else {
                field.getBeanField().setObjectFieldValue(object, newValue);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            ObjectException exception = new ObjectException(500, "\u521b\u5efaEmbeddedId \u5b9e\u4f8b\u9519\u8bef", (Throwable)e);
            exception.setObjectData((Object)this);
            throw exception;
        }
    }

    public Object getObjectFieldValue(Object object, String fieldName) {
        SimpleTableField field = this.findFieldByName(fieldName);
        if (field == null) {
            return null;
        }
        return this.getObjectFieldValue(object, field);
    }

    public void setObjectFieldValue(Object object, String fieldName, Object newValue) {
        SimpleTableField field = this.findFieldByName(fieldName);
        if (field == null) {
            return;
        }
        this.setObjectFieldValue(object, field, newValue);
    }

    public Map<String, Object> fetchObjectPk(Object object) {
        HashMap<String, Object> pk = new HashMap<String, Object>(8);
        List<SimpleTableField> columns = this.getColumns();
        if (columns != null) {
            for (SimpleTableField c : columns) {
                if (!c.isPrimaryKey()) continue;
                Object pkValue = this.getObjectFieldValue(object, c);
                if (pkValue == null) {
                    return null;
                }
                pk.put(c.getPropertyName(), pkValue);
            }
        }
        return pk;
    }
}

