package com.centit.support.database.ddl;

import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.utils.QueryUtils;
import org.apache.commons.lang3.StringUtils;

import java.sql.Connection;

public class PostgreSqlDDLOperations extends GeneralDDLOperations {

    public PostgreSqlDDLOperations() {

    }

    public PostgreSqlDDLOperations(Connection conn) {
        super(conn);
    }

    @Override
    public String makeCreateSequenceSql(final String sequenceName) {
        return "create sequence " + QueryUtils.trimSqlIdentifier(sequenceName);
    }

    /**
     * 修改列定义 ，比如 修改 varchar 的长度
     *
     * @param tableCode 表代码
     * @param oldColumn 老的字段
     * @param column    字段
     * @return sql语句
     */
    @Override
    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        Boolean modify=false;
        sbsql.append(tableCode);
        sbsql.append(" ALTER ").append(column.getColumnName()).append(" ");
        if (!StringUtils.equalsIgnoreCase(oldColumn.getColumnType(), column.getColumnType())
            || !GeneralAlgorithm.equals(oldColumn.getMaxLength(), column.getMaxLength())
            || !GeneralAlgorithm.equals(oldColumn.getScale(), column.getScale())) {
            sbsql.append(" type ");
            appendColumnTypeSQL(column, sbsql);
            modify=true;
        }

        if (oldColumn.isMandatory() != column.isMandatory()) {
            if(modify) {
                sbsql.append(";alter table "+tableCode);
                sbsql.append(" ALTER ").append(column.getColumnName()).append(" ");
            }
            sbsql.append(column.isMandatory() ? " set not null" : " drop not null");
        }

        return sbsql.toString();
    }


}
