/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.utils.QueryUtils;
import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;

public class PostgreSqlDDLOperations
extends GeneralDDLOperations {
    public PostgreSqlDDLOperations() {
    }

    public PostgreSqlDDLOperations(Connection conn) {
        super(conn);
    }

    @Override
    public String makeCreateSequenceSql(String sequenceName) {
        return "create sequence " + QueryUtils.cleanSqlStatement(sequenceName);
    }

    @Override
    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" ALTER ").append(column.getColumnName()).append(" ");
        if (!StringUtils.equalsIgnoreCase((CharSequence)oldColumn.getColumnType(), (CharSequence)column.getColumnType()) || oldColumn.getMaxLength() != column.getMaxLength() || oldColumn.getPrecision() != column.getPrecision()) {
            sbsql.append(" type ");
            this.appendColumnTypeSQL(column, sbsql);
        }
        if (oldColumn.isMandatory() != column.isMandatory()) {
            sbsql.append(column.isMandatory() ? " set not null" : " drop not null");
        }
        return sbsql.toString();
    }
}

