/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MySqlDDLOperations
extends GeneralDDLOperations {
    public MySqlDDLOperations() {
    }

    public MySqlDDLOperations(Connection conn) {
        super(conn);
    }

    @Override
    protected void appendPkSql(TableInfo tableInfo, StringBuilder sbCreate) {
        if (tableInfo.getPkColumns() != null && tableInfo.getPkColumns().size() > 0) {
            sbCreate.append(" primary key ");
            this.appendPkColumnSql(tableInfo, sbCreate);
        }
    }

    @Override
    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" MODIFY COLUMN  ").append(column.getColumnName()).append(" ");
        if (!StringUtils.equalsIgnoreCase((CharSequence)oldColumn.getColumnType(), (CharSequence)column.getColumnType()) || oldColumn.getMaxLength() != column.getMaxLength() || oldColumn.getPrecision() != column.getPrecision()) {
            this.appendColumnTypeSQL(column, sbsql);
        }
        if (oldColumn.isMandatory() != column.isMandatory()) {
            sbsql.append(column.isMandatory() ? " not null" : " null");
        }
        return sbsql.toString();
    }

    @Override
    public String makeRenameColumnSql(String tableCode, String columnCode, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" CHANGE ");
        sbsql.append(columnCode);
        sbsql.append(" ");
        sbsql.append(column.getColumnName());
        sbsql.append(" ");
        this.appendColumnTypeSQL(column, sbsql);
        return sbsql.toString();
    }

    @Override
    public List<String> makeReconfigurationColumnSqls(String tableCode, String columnCode, TableField column) {
        ArrayList<String> sqls = new ArrayList<String>();
        SimpleTableField tempColumn = new SimpleTableField();
        tempColumn.setColumnName(columnCode + "_1");
        sqls.add(this.makeRenameColumnSql(tableCode, columnCode, tempColumn));
        sqls.add(this.makeAddColumnSql(tableCode, column));
        if ("string".equals(column.getFieldType()) || "text".equals(column.getFieldType()) || "fileId".equals(column.getFieldType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = cast(" + columnCode + "_1 as char)");
        } else if ("date".equals(column.getFieldType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = cast(" + columnCode + "_1 as date)");
        } else if ("timestamp".equals(column.getFieldType()) || "datetime".equals(column.getFieldType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = cast(" + columnCode + "_1 as datetime)");
        } else if ("long".equals(column.getFieldType()) || "integer".equals(column.getFieldType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = cast(" + columnCode + "_1 as signed)");
        } else if ("float".equals(column.getFieldType()) || "double".equals(column.getFieldType())) {
            sqls.add("update " + tableCode + " set " + column.getColumnName() + " = cast(" + columnCode + "_1 as decimal(" + column.getMaxLength() + "," + column.getScale() + ")");
        }
        sqls.add(this.makeDropColumnSql(tableCode, columnCode + "_1"));
        return sqls;
    }
}

