/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.centit.support.database.metadata.IDatabaseInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DataSourceDescription;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbcpConnectPools {
    private static final Logger logger = LoggerFactory.getLogger(DbcpConnectPools.class);
    private static final ConcurrentHashMap<DataSourceDescription, HikariDataSource> dbcpDataSourcePools = new ConcurrentHashMap();

    private DbcpConnectPools() {
        throw new IllegalAccessError("Utility class");
    }

    private static HikariDataSource mapDataSource(DataSourceDescription dsDesc) {
        HikariDataSource ds = new HikariDataSource();
        ds.setDriverClassName(dsDesc.getDriver());
        ds.setUsername(dsDesc.getUsername());
        ds.setPassword(dsDesc.getPassword());
        ds.setJdbcUrl(dsDesc.getConnUrl());
        ds.setConnectionTimeout((long)dsDesc.getMaxWaitMillis());
        ds.setMaximumPoolSize(dsDesc.getMaxTotal());
        ds.setMaxLifetime(1800000L);
        ds.setIdleTimeout(60000L);
        ds.setValidationTimeout(5000L);
        ds.setMinimumIdle(dsDesc.getMinIdle());
        String validationQuery = DBType.getDBValidationQuery((DBType)dsDesc.getDbType());
        if (StringUtils.isNotBlank((CharSequence)validationQuery)) {
            ds.setConnectionTestQuery(validationQuery);
        }
        return ds;
    }

    public static synchronized HikariDataSource getDataSource(DataSourceDescription dsDesc) {
        HikariDataSource ds = dbcpDataSourcePools.get(dsDesc);
        if (ds == null) {
            ds = DbcpConnectPools.mapDataSource(dsDesc);
            dbcpDataSourcePools.put(dsDesc, ds);
        }
        return ds;
    }

    public static synchronized Connection getDbcpConnect(DataSourceDescription dsDesc) throws SQLException {
        HikariDataSource ds = DbcpConnectPools.getDataSource(dsDesc);
        Connection conn = ds.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    public static HikariDataSource getDataSource(IDatabaseInfo dbinfo) {
        return DbcpConnectPools.getDataSource(DataSourceDescription.valueOf(dbinfo));
    }

    public static Connection getDbcpConnect(IDatabaseInfo dbinfo) throws SQLException {
        return DbcpConnectPools.getDbcpConnect(DataSourceDescription.valueOf(dbinfo));
    }

    public static Map<String, Object> getDataSourceStats(DataSourceDescription dsDesc) {
        HikariDataSource bds = dbcpDataSourcePools.get(dsDesc);
        if (bds == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("poolName", bds.getPoolName());
        return map;
    }

    public static synchronized void shutdownDataSource() {
        for (Map.Entry<DataSourceDescription, HikariDataSource> dbs : dbcpDataSourcePools.entrySet()) {
            dbs.getValue().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean testDataSource(DataSourceDescription dsDesc) {
        boolean connOk = false;
        try (HikariDataSource ds = DbcpConnectPools.mapDataSource(dsDesc);){
            Connection conn = ds.getConnection();
            if (conn != null) {
                connOk = true;
                conn.close();
            }
            ds.close();
        }
        return connOk;
    }

    public static void closeConnect(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

