/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.team.utils;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.ObjectException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public abstract class ResourceLock {
    public static final int MAX_ACTIVE_TIME_SECONDS = 360000;
    static ConcurrentHashMap<String, LockUser> resourceLockMap = new ConcurrentHashMap(1000);

    public static void lockResource(String resourceId, String lockUser) {
        if (StringUtils.isBlank((CharSequence)resourceId) || StringUtils.isBlank((CharSequence)lockUser)) {
            return;
        }
        LockUser lockInfo = resourceLockMap.get(resourceId);
        Date currentTime = DatetimeOpt.currentUtilDate();
        if (lockInfo == null) {
            resourceLockMap.put(resourceId, new LockUser(lockUser, currentTime));
            return;
        }
        if (StringUtils.equals((CharSequence)lockUser, (CharSequence)lockInfo.getUserCode())) {
            lockInfo.setLockedTime(currentTime);
            return;
        }
        if (currentTime.getTime() - lockInfo.getLockedTime().getTime() > 360000L) {
            lockInfo.setUserCode(lockUser);
            lockInfo.setLockedTime(currentTime);
            resourceLockMap.put(resourceId, lockInfo);
            return;
        }
        throw new ObjectException((Object)lockInfo.getUserCode(), 611, "\u8d44\u6e90\uff1a" + resourceId + " \u5df2\u88ab\u7528\u6237\uff1a" + lockInfo.getUserCode() + " \u9501\u5b9a\u3002");
    }

    public static boolean releaseLock(String resourceId, String lockUser) {
        if (StringUtils.isBlank((CharSequence)resourceId) || StringUtils.isBlank((CharSequence)lockUser)) {
            return true;
        }
        LockUser lockInfo = resourceLockMap.get(resourceId);
        if (lockInfo == null) {
            return true;
        }
        if (StringUtils.equals((CharSequence)lockUser, (CharSequence)lockInfo.getUserCode())) {
            resourceLockMap.remove(resourceId);
            return true;
        }
        return false;
    }

    public static void releaseAll(String lockUser) {
        if (StringUtils.isBlank((CharSequence)lockUser)) {
            return;
        }
        for (Map.Entry<String, LockUser> ent : resourceLockMap.entrySet()) {
            if (!lockUser.equals(ent.getValue().getUserCode())) continue;
            resourceLockMap.remove(ent.getKey());
        }
    }

    static class LockUser {
        String userCode;
        Date lockedTime;

        public String getUserCode() {
            return this.userCode;
        }

        public Date getLockedTime() {
            return this.lockedTime;
        }

        public void setUserCode(String userCode) {
            this.userCode = userCode;
        }

        public void setLockedTime(Date lockedTime) {
            this.lockedTime = lockedTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LockUser)) {
                return false;
            }
            LockUser other = (LockUser)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userCode = this.getUserCode();
            String other$userCode = other.getUserCode();
            if (this$userCode == null ? other$userCode != null : !this$userCode.equals(other$userCode)) {
                return false;
            }
            Date this$lockedTime = this.getLockedTime();
            Date other$lockedTime = other.getLockedTime();
            return !(this$lockedTime == null ? other$lockedTime != null : !((Object)this$lockedTime).equals(other$lockedTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LockUser;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userCode = this.getUserCode();
            result = result * 59 + ($userCode == null ? 43 : $userCode.hashCode());
            Date $lockedTime = this.getLockedTime();
            result = result * 59 + ($lockedTime == null ? 43 : ((Object)$lockedTime).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceLock.LockUser(userCode=" + this.getUserCode() + ", lockedTime=" + this.getLockedTime() + ")";
        }

        public LockUser(String userCode, Date lockedTime) {
            this.userCode = userCode;
            this.lockedTime = lockedTime;
        }
    }
}

