package com.centit.tablestore.service;

import com.alibaba.fastjson2.JSONObject;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.ProjectHistory;

import java.util.List;
import java.util.Map;

public interface ProjectHistoryService {

    void saveProjectHistory(ProjectHistory historyInfo);

    void updateProjectHistory(ProjectHistory historyInfo);

    void deleteProjectHistory(String historyId);

    ProjectHistory getProjectHistory(String historyId);

    void restoreProjectHistory(String historyId, String userCode);

    List<ProjectHistory> listProjectHistory(Map<String, Object> params, PageDesc pageDesc);

    void restoreProject(String projectId, JSONObject projectInfo, String userCode);

    void mergeProject(String projectId, JSONObject projectInfo, String userCode);
}
