package com.centit.tablestore.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.tablestore.po.ProjectInfo;
import org.springframework.stereotype.Repository;

import java.util.Map;

@Repository
public class ProjectInfoDao extends BaseDaoImpl<ProjectInfo, String> {

    @Override
    public Map<String, String> getFilterField() {
        return null;
    }

    public boolean checkOwner(String projectId, String userCode){
        return NumberBaseOpt.castObjectToInteger(
                DatabaseOptUtils.getScalarObjectQuery( this,
                "select count(1) as projectSum from TS_PROJECT_INFO a " +
                        "where a.PROJECT_ID = ? and a.CREATOR_CODE = ?",
                new Object[]{projectId, userCode}), 0) > 0;
    }

    /**
     *
     * @param projectInfo 项目对象
     * @param changFollowed 1；增加followed 2：减少followed
     */
    public void updateSortScore(ProjectInfo projectInfo, int changFollowed){
        projectInfo.calcSortScore();
        String sqlSen = "update TS_PROJECT_INFO set TABLE_FORKED_TIMES =?, PROJECT_FORKED_TIMES = ?," +
                "TABLE_VIEWED_TIMES= ?, SORT_SCORE= ?";
        if(changFollowed==1){
            sqlSen = sqlSen +",FOLLOWED_SUM = IFNULL(FOLLOWED_SUM,0) + 1";
        } else  if(changFollowed==2){
            sqlSen = sqlSen +",FOLLOWED_SUM = FOLLOWED_SUM - 1";
        }

        DatabaseOptUtils.doExecuteSql(this,sqlSen +" where PROJECT_ID =?",
                new Object[]{projectInfo.getTableForkedTimes(), projectInfo.getProjectForkedTimes(),
                        projectInfo.getTableViewedTimes(), projectInfo.getSortScore(), projectInfo.getProjectId()});
    }
}
