/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.dao.ProjectFollowerDao;
import com.centit.tablestore.dao.ProjectInfoDao;
import com.centit.tablestore.dao.ProjectModuleDao;
import com.centit.tablestore.dao.ProjectTeamDao;
import com.centit.tablestore.dao.TableStructDao;
import com.centit.tablestore.po.ProjectFollower;
import com.centit.tablestore.po.ProjectFollowerId;
import com.centit.tablestore.po.ProjectInfo;
import com.centit.tablestore.po.ProjectModule;
import com.centit.tablestore.po.ProjectTeam;
import com.centit.tablestore.po.ProjectTeamId;
import com.centit.tablestore.po.TableStruct;
import com.centit.tablestore.service.ProjectInfoService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectInfoService")
@Transactional
public class ProjectInfoServiceImpl
implements ProjectInfoService {
    @Autowired
    protected ProjectInfoDao projectInfoDao;
    @Autowired
    protected ProjectModuleDao projectModuleDao;
    @Autowired
    protected TableStructDao tableStructDao;
    @Autowired
    protected ProjectTeamDao projectTeamDao;
    @Autowired
    protected ProjectFollowerDao projectFollowerDao;
    @Autowired
    protected PlatformEnvironment platformEnvironment;

    private void saveProjectInfo(ProjectInfo projectInfo) {
        this.projectInfoDao.saveNewObject(projectInfo);
        ProjectTeam pt = new ProjectTeam(projectInfo.getProjectId(), projectInfo.getCreatorCode());
        pt.setMemberName(projectInfo.getCreatorName());
        this.projectTeamDao.saveNewObject(pt);
    }

    @Override
    public void createNewProject(ProjectInfo projectInfo) {
        this.saveProjectInfo(projectInfo);
        ProjectModule projectModule = new ProjectModule();
        projectModule.setProjectId(projectInfo.getProjectId());
        projectModule.setCreatorCode(projectInfo.getCreatorCode());
        projectModule.setModuleName("\u9ed8\u8ba4\u6a21\u5757");
        projectModule.setModuleDesc("\u968f\u9879\u76ee\u540c\u65f6\u521b\u5efa\u7684\u9ed8\u8ba4\u6a21\u5757\u3002");
        this.projectModuleDao.saveNewObject(projectModule);
    }

    @Override
    public void updateProjectInfo(ProjectInfo projectInfo) {
        this.projectInfoDao.updateObject(projectInfo);
    }

    @Override
    public void deleteProjectInfo(String projectId) {
        this.projectInfoDao.deleteObjectById(projectId);
        this.projectModuleDao.deleteProjectModule(projectId);
        this.tableStructDao.deleteProjectTable(projectId);
        this.projectTeamDao.deleteProjectTeam(projectId);
    }

    @Override
    public ProjectInfo getProjectInfo(String projectId) {
        return (ProjectInfo)this.projectInfoDao.getObjectById(projectId);
    }

    @Override
    public JSONArray listUserProjects(String userCode, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.projectInfoDao, (String)"select a.* from TS_PROJECT_INFO a join TS_PROJECT_TEAM b on(a.PROJECT_ID= b.PROJECT_ID) where b.PROJECT_MEMBER = ?", (Object[])new Object[]{userCode}, (PageDesc)pageDesc);
    }

    @Override
    public JSONArray listFollowerProjects(String userCode, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.projectInfoDao, (String)"select a.* from TS_PROJECT_INFO a join TS_PROJECT_FOLLOWER b on(a.PROJECT_ID= b.PROJECT_ID) where b.PROJECT_FOLLOWER = ?", (Object[])new Object[]{userCode}, (PageDesc)pageDesc);
    }

    @Override
    public Map<String, Object> getUserStatInfo(String userCode) {
        int projects = NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this.projectTeamDao, (String)"select count(1) as projectSum from TS_PROJECT_TEAM a where a.PROJECT_MEMBER = ?", (Object[])new Object[]{userCode}), (Integer)0);
        int tables = NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this.projectTeamDao, (String)"select count(1) as tableSum from TS_TABLE_STRUCT a where a.CREATOR_CODE = ?", (Object[])new Object[]{userCode}), (Integer)0);
        int moudles = NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this.projectTeamDao, (String)"select count(1) as moduleSum from TS_PROJECT_MODULE a where a.CREATOR_CODE = ?", (Object[])new Object[]{userCode}), (Integer)0);
        Map objectMap = CollectionsOpt.createHashMap((Object[])new Object[]{"projectSum", projects, "tableSum", tables, "moduleSum", moudles, "userCode", userCode});
        CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByUserCode(userCode);
        if (ud != null) {
            objectMap.put("userName", ud.getUserInfo().getString("userName"));
            objectMap.put("email", ud.getUserInfo().getString("regEmail"));
        }
        return objectMap;
    }

    @Override
    public JSONArray listUserCreateProjects(String userCode, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this.projectInfoDao, (String)"select a.* from TS_PROJECT_INFO a where a.CREATOR_CODE=?", (Object[])new Object[]{userCode}, (PageDesc)pageDesc);
    }

    @Override
    public void addProjectMember(String optUser, String projectId, String memberCode) {
        if (!this.projectInfoDao.checkOwner(projectId, optUser)) {
            throw new ObjectException(403, "\u7528\u6237 " + optUser + " \u4e0d\u662f\u9879\u76ee " + projectId + " \u7684\u521b\u5efa\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002");
        }
        ProjectTeam pt = (ProjectTeam)this.projectTeamDao.getObjectById(new ProjectTeamId(projectId, memberCode));
        if (pt != null) {
            return;
        }
        pt = new ProjectTeam(projectId, memberCode);
        CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByUserCode(memberCode);
        if (ud != null) {
            pt.setMemberName(ud.getUserInfo().getString("userName"));
        }
        this.projectTeamDao.saveNewObject(pt);
    }

    @Override
    public void deleteProjectMember(String optUser, String projectId, String memberCode) {
        if (!this.projectInfoDao.checkOwner(projectId, optUser)) {
            throw new ObjectException(403, "\u7528\u6237 " + optUser + " \u4e0d\u662f\u9879\u76ee " + projectId + " \u7684\u521b\u5efa\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002");
        }
        if (!optUser.equals(memberCode)) {
            this.projectTeamDao.deleteObjectById(new ProjectTeamId(projectId, memberCode));
        }
    }

    @Override
    public List<ProjectTeam> listProjectMember(String optUser, String projectId) {
        if (!this.projectInfoDao.checkOwner(projectId, optUser)) {
            throw new ObjectException(403, "\u7528\u6237 " + optUser + " \u4e0d\u662f\u9879\u76ee " + projectId + " \u7684\u521b\u5efa\u4eba\uff0c\u65e0\u6743\u64cd\u4f5c\u3002");
        }
        return this.projectTeamDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}));
    }

    @Override
    public void addFollowerProject(ProjectFollower follower) {
        ProjectFollower pf = (ProjectFollower)this.projectFollowerDao.getObjectById(follower.getPfId());
        if (pf == null) {
            this.projectFollowerDao.saveNewObject(follower);
            ProjectInfo projectInfo = (ProjectInfo)this.projectInfoDao.getObjectById(follower.getProjectId());
            projectInfo.setFollowedSum(projectInfo.getFollowedSum() + 1L);
            this.projectInfoDao.updateSortScore(projectInfo, 1);
        }
    }

    @Override
    public void deleteFollowerProject(String optUser, String projectId) {
        ProjectFollowerId fid = new ProjectFollowerId(projectId, optUser);
        ProjectFollower pf = (ProjectFollower)this.projectFollowerDao.getObjectById(fid);
        if (pf != null) {
            this.projectFollowerDao.deleteObjectById(fid);
            ProjectInfo projectInfo = (ProjectInfo)this.projectInfoDao.getObjectById(projectId);
            projectInfo.setFollowedSum(projectInfo.getFollowedSum() - 1L);
            this.projectInfoDao.updateSortScore(projectInfo, 2);
        }
    }

    @Override
    public ProjectInfo forkProject(CentitUserDetails userDetails, String projectId) {
        List modules;
        ProjectInfo projectInfo = (ProjectInfo)this.projectInfoDao.getObjectById(projectId);
        if (projectInfo == null) {
            throw new ObjectException(800, "\u9879\u76ee " + projectId + " \u4e0d\u5b58\u5728\u3002");
        }
        if (StringUtils.equals((CharSequence)userDetails.getUserCode(), (CharSequence)projectInfo.getCreatorCode())) {
            throw new ObjectException(800, "\u7528\u6237 " + userDetails.getUserCode() + " \u4e0d\u80fdfork\u81ea\u5df1\u7684\u9879\u76ee\u3002");
        }
        ProjectInfo forkProject = (ProjectInfo)this.projectInfoDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"creatorCode", userDetails.getUserCode(), "forkProject", projectId}));
        if (forkProject != null) {
            throw new ObjectException(611, "\u5df2\u7ecf\u5b58\u5728\u4e00\u4e2a\u76f8\u540c\u7684fork\u9879\u76ee\uff0c\u907f\u514d\u6570\u636e\u5197\u4f59\u4e0d\u80fd\u518d\u6b21fork\uff0c\u53ef\u4ee5\u7528\u5bfc\u5165\u5bfc\u51fa\u6765\u66f4\u65b0\u6700\u65b0\u7684\u9879\u76ee\u6570\u636e\u3002");
        }
        String userName = userDetails.getUserInfo().getString("userName");
        projectInfo.setProjectForkedTimes(projectInfo.getProjectForkedTimes() + 1L);
        this.projectInfoDao.updateSortScore(projectInfo, 0);
        forkProject = projectInfo;
        forkProject.setProjectId(UuidOpt.getUuidAsString22());
        forkProject.setForkProject(projectId);
        forkProject.setCreatorCode(userDetails.getUserCode());
        forkProject.setCreatorName(userName);
        forkProject.clearSortScore();
        this.saveProjectInfo(forkProject);
        HashMap<String, String> tableIdMap = new HashMap<String, String>(100);
        List tables = this.tableStructDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}));
        if (tables != null) {
            for (TableStruct ts : tables) {
                String newTableId = UuidOpt.getUuidAsString22();
                tableIdMap.put(ts.getTableId(), newTableId);
                ts.setTableId(newTableId);
                ts.setProjectId(forkProject.getProjectId());
                ts.setCreatorCode(userDetails.getUserCode());
                ts.setCreatorName(userName);
                this.tableStructDao.saveNewObject(ts);
            }
        }
        if ((modules = this.projectModuleDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}))) != null) {
            for (ProjectModule pm : modules) {
                Object views;
                pm.setModuleId(UuidOpt.getUuidAsString22());
                pm.setProjectId(forkProject.getProjectId());
                pm.setCreatorCode(userDetails.getUserCode());
                Object moduleTables = pm.getModuleDesign().get("tables");
                if (moduleTables instanceof List) {
                    for (Object table : (List)moduleTables) {
                        Map tableMap;
                        Object tableInfo;
                        if (!(table instanceof Map) || !((tableInfo = (tableMap = (Map)table).get("info")) instanceof JSONObject)) continue;
                        String oldTalbeId = StringBaseOpt.castObjectToString((Object)((JSONObject)tableInfo).get("tableId"));
                        String newTableId = (String)tableIdMap.get(oldTalbeId);
                        if (newTableId == null) {
                            newTableId = "";
                        }
                        ((JSONObject)tableInfo).put((Object)"tableId", (Object)newTableId);
                    }
                }
                if ((views = pm.getModuleDesign().get("views")) instanceof List) {
                    for (Object view : (List)views) {
                        Map viewMap;
                        Object viewInfo;
                        if (!(view instanceof Map) || !((viewInfo = (viewMap = (Map)view).get("info")) instanceof JSONObject)) continue;
                        String oldTalbeId = StringBaseOpt.castObjectToString((Object)((JSONObject)viewInfo).get("viewId"));
                        String newTableId = (String)tableIdMap.get(oldTalbeId);
                        if (newTableId == null) {
                            newTableId = "";
                        }
                        ((JSONObject)viewInfo).put((Object)"viewId", (Object)newTableId);
                    }
                }
                this.projectModuleDao.saveNewObject(pm);
            }
        }
        return forkProject;
    }

    @Override
    public boolean hasFollowedProject(String projectId, String userCode) {
        return this.projectFollowerDao.hasFollowed(projectId, userCode);
    }

    @Override
    public boolean checkMember(String projectId, String userCode) {
        return this.projectTeamDao.checkMember(projectId, userCode);
    }

    @Override
    public void mergeProjectTables(String projectId, CentitUserDetails userDetails, List<TableStruct> tableStructs) {
        if (!this.projectTeamDao.checkMember(projectId, userDetails.getUserCode())) {
            throw new ObjectException(403, "\u7528\u6237 " + userDetails.getUserCode() + " \u65e0\u6743\u64cd\u4f5c " + projectId + " \u9879\u76ee\u3002");
        }
        String userName = userDetails.getUserInfo().getString("userName");
        for (TableStruct struct : tableStructs) {
            struct.setProjectId(projectId);
            struct.setCreatorCode(userDetails.getUserCode());
            struct.setCreatorName(userName);
            this.tableStructDao.mergeTable(struct, projectId);
        }
    }

    @Override
    public String makeCreateSql(String projectId, DBType dbType) {
        StringBuilder sqlBuilder = new StringBuilder("/*==========================================*/\r\n/* Created on:   ").append(DatetimeOpt.currentDatetime()).append("                        */\r\n/*==========================================*/\r\n");
        List<TableStruct> tables = this.tableStructDao.listProjectTableWithColumn(projectId);
        StringBuilder viewSqlBuilder = new StringBuilder();
        if (tables != null) {
            for (TableStruct struct : tables) {
                if ("V".equals(struct.getTableType())) {
                    viewSqlBuilder.append("/*===  ").append(struct.getTableLabelName()).append("  =======*/\r\n").append(struct.buildCreateTableSql(dbType)).append("\r\n\r\n");
                    continue;
                }
                sqlBuilder.append("/*===  ").append(struct.getTableLabelName()).append("  =======*/\r\n").append(struct.buildCreateTableSql(dbType)).append("\r\n\r\n");
            }
        }
        sqlBuilder.append((CharSequence)viewSqlBuilder);
        return sqlBuilder.toString();
    }

    @Override
    public JSONObject exportProject(String projectId) {
        List<TableStruct> tables;
        JSONObject project = new JSONObject();
        project.put((Object)"projectInfo", (Object)this.projectInfoDao.getObjectById(projectId));
        List<ProjectModule> modules = this.projectModuleDao.listProjectModuleWithDesign(projectId);
        if (modules != null && modules.size() > 0) {
            JSONArray jaModules = new JSONArray();
            for (ProjectModule module : modules) {
                jaModules.add((Object)module.toModuleJson());
            }
            project.put((Object)"modules", (Object)jaModules);
        }
        if ((tables = this.tableStructDao.listProjectTableWithColumn(projectId)) != null && tables.size() > 0) {
            JSONArray jaTables = new JSONArray();
            for (TableStruct table : tables) {
                jaTables.add((Object)table.toTableJson());
            }
            project.put((Object)"tables", (Object)jaTables);
        }
        return project;
    }
}

