/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.dao.ProjectHistoryDao;
import com.centit.tablestore.dao.ProjectInfoDao;
import com.centit.tablestore.dao.ProjectModuleDao;
import com.centit.tablestore.dao.TableStructDao;
import com.centit.tablestore.po.ProjectHistory;
import com.centit.tablestore.po.ProjectInfo;
import com.centit.tablestore.po.ProjectModule;
import com.centit.tablestore.po.TableStruct;
import com.centit.tablestore.service.ProjectHistoryService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectHistoryService")
@Transactional
public class ProjectHistoryServiceImpl
implements ProjectHistoryService {
    @Autowired
    protected ProjectModuleDao projectModuleDao;
    @Autowired
    protected ProjectInfoDao projectInfoDao;
    @Autowired
    protected TableStructDao tableStructDao;
    @Autowired
    protected ProjectHistoryDao projectHistoryDao;

    @Override
    public void saveProjectHistory(ProjectHistory historyInfo) {
        this.projectHistoryDao.saveNewObject(historyInfo);
    }

    @Override
    public void updateProjectHistory(ProjectHistory historyInfo) {
        this.projectHistoryDao.updateObject(historyInfo);
    }

    @Override
    public void deleteProjectHistory(String historyId) {
        this.projectHistoryDao.deleteProjectHistory(historyId);
    }

    @Override
    public ProjectHistory getProjectHistory(String historyId) {
        return (ProjectHistory)this.projectHistoryDao.getObjectById(historyId);
    }

    @Override
    public void restoreProjectHistory(String historyId) {
        ProjectHistory history = (ProjectHistory)this.projectHistoryDao.getObjectById(historyId);
        if (history == null) {
            throw new ObjectException(604, "\u6ca1\u6709\u627e\u5230\u5386\u53f2\u7248\u672c\u4fe1\u606f\uff1a" + historyId + " \u3002");
        }
        this.restoreProject(history.getProjectId(), history.getStructContent());
    }

    @Override
    public List<ProjectHistory> listProjectHistory(Map<String, Object> params, PageDesc pageDesc) {
        return this.projectHistoryDao.listObjectsByProperties(params, pageDesc);
    }

    public void restoreOrMergeProject(String projectId, JSONObject projectInfo, boolean merge) {
        JSONArray modules;
        JSONObject project = projectInfo.getJSONObject("projectInfo");
        ProjectInfo pi = (ProjectInfo)this.projectInfoDao.getObjectById(projectId);
        if (pi == null) {
            throw new ObjectException(604, "\u6ca1\u6709\u627e\u5230\u54cd\u5e94\u7684\u9879\u76ee\u4fe1\u606f\uff1a" + projectId + " \u3002");
        }
        pi.setProjectName(project.getString("projectName"));
        pi.setIndustryCategory(project.getString("industryCategory"));
        pi.setProjectDesc(project.getString("projectDesc"));
        this.projectInfoDao.updateObject(pi);
        if (!merge) {
            this.tableStructDao.deleteProjectTable(projectId);
        }
        HashMap<String, String> tableIdMap = new HashMap<String, String>(128);
        JSONArray tables = projectInfo.getJSONArray("tables");
        if (tables != null && tables.size() > 0) {
            for (Object obj : tables) {
                TableStruct ts;
                if (!(obj instanceof JSONObject) || !StringUtils.isNotBlank((CharSequence)(ts = TableStruct.formTableJson((JSONObject)obj)).getTableName())) continue;
                String newTableId = UuidOpt.getUuidAsString22();
                tableIdMap.put(ts.getTableId(), newTableId);
                ts.setTableId(newTableId);
                ts.setProjectId(projectId);
                if (merge) {
                    this.tableStructDao.mergeTable(ts, projectId);
                    continue;
                }
                this.tableStructDao.saveNewObject(ts);
            }
        }
        if (!merge) {
            this.projectModuleDao.deleteProjectModule(projectId);
        }
        if ((modules = projectInfo.getJSONArray("modules")) != null && modules.size() > 0) {
            for (Object obj : modules) {
                ProjectModule pm;
                if (!(obj instanceof JSONObject) || !StringUtils.isNotBlank((CharSequence)(pm = ProjectModule.formModuleJson((JSONObject)obj)).getModuleName())) continue;
                pm.setProjectId(projectId);
                pm.setModuleId(UuidOpt.getUuidAsString22());
                pm.replaceModuleTablesId(tableIdMap);
                if (merge) {
                    this.projectModuleDao.mergeProjectModule(pm);
                    continue;
                }
                this.projectModuleDao.saveNewObject(pm);
            }
        }
    }

    @Override
    public void restoreProject(String projectId, JSONObject projectInfo) {
        this.restoreOrMergeProject(projectId, projectInfo, false);
    }

    @Override
    public void mergeProject(String projectId, JSONObject projectInfo) {
        this.restoreOrMergeProject(projectId, projectInfo, true);
    }
}

