/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.po;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.FieldType;
import com.centit.tablestore.po.TableIndexInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@ApiModel
@Entity
@Table(name="TS_TABLE_STRUCT")
public class TableStruct
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="TABLE_ID")
    @ApiModelProperty(value="\u8868ID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String tableId;
    @Column(name="PROJECT_ID")
    @ApiModelProperty(value="\u9879\u76eeID")
    private String projectId;
    @Column(name="TABLE_TYPE")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Pattern(regexp="[TVC]")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u8868\u7c7b\u522b\uff08T-\u8868\uff1bV-\u89c6\u56fe\uff1bC-\u5927\u5b57\u6bb5\uff09")
    @DictionaryMap(fieldName={"tableTypeText"}, value={"TableType"})
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="[TVC]") @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableType = "T";
    @Column(name="TABLE_NAME")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u8868\u540d")
    @OrderBy
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableName;
    @Column(name="TABLE_LABEL_NAME")
    @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u8868\u4e2d\u6587\u540d")
    private @NotBlank(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=100, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableLabelName;
    @ApiModelProperty(value="\u8868\u63cf\u8ff0")
    @Column(name="TABLE_COMMENT")
    @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=256, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String tableComment;
    @Column(name="CREATOR_CODE")
    @ApiModelProperty(value="\u8868\u521b\u5efa\u4eba")
    private String creatorCode;
    @Column(name="CREATOR_NAME")
    @ApiModelProperty(value="\u8868\u521b\u5efa\u4eba\u59d3\u540d")
    private String creatorName;
    @Column(name="LAST_UPDATE_TIME")
    @ApiModelProperty(value="\u6700\u540e\u66f4\u65b0\u65f6\u95f4")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date lastUpdateTIme;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="COLUMN_FIELD_JSON")
    @ApiModelProperty(value="\u5b57\u6bb5\u4fe1\u606fJSON")
    private JSONObject metadataJson = new JSONObject();
    @Column(name="FULLTEXT_INDEX")
    @Basic(fetch=FetchType.LAZY)
    @JSONField(serialize=false, deserialize=false)
    @ApiModelProperty(value="\u5168\u6587\u68c0\u7d22\u5b57\u6bb5")
    private String fulltextIndex;
    @Column(name="VIEW_TIMES")
    @ApiModelProperty(value="\u88ab\u67e5\u770b\u6b21\u6570\uff0c\u590d\u5236sql\u8bed\u53e5\u3001\u5bfc\u51fa\u89c6\u4e3a\u6709\u6548\u67e5\u770b")
    private Long viewTimes;

    public String getFulltextIndex() {
        StringBuilder textBuilder = new StringBuilder(this.tableName).append(" ").append(this.tableLabelName).append(" ").append(this.tableComment).append(";");
        Object columns = this.metadataJson.get("columns");
        if (columns instanceof List) {
            for (Object col : (List)columns) {
                if (!(col instanceof Map)) continue;
                Map colMap = (Map)col;
                textBuilder.append(" ").append(colMap.get("columnName")).append(" ").append(colMap.get("fieldLabelName"));
                Object comments = colMap.get("columnComment");
                if (comments == null) continue;
                textBuilder.append(" ").append(comments).append(";");
            }
        }
        this.fulltextIndex = textBuilder.toString();
        return this.fulltextIndex;
    }

    public List<TableIndexInfo> fetchIndexes() {
        if (this.metadataJson == null) {
            return null;
        }
        JSONArray indexes = this.metadataJson.getJSONArray("indexes");
        if (indexes == null || indexes.size() == 0) {
            return null;
        }
        ArrayList<TableIndexInfo> tableIndexes = new ArrayList<TableIndexInfo>();
        for (Object obj : indexes) {
            if (!(obj instanceof JSONObject)) continue;
            JSONObject indJson = (JSONObject)obj;
            TableIndexInfo ind = (TableIndexInfo)indJson.toJavaObject(TableIndexInfo.class, new JSONReader.Feature[0]);
            tableIndexes.add(ind);
        }
        return tableIndexes;
    }

    public String extraViewSql() {
        return StringBaseOpt.castObjectToString((Object)this.metadataJson.get("viewSql"));
    }

    public SimpleTableInfo toTableInfo(DBType dt) {
        Object columns;
        SimpleTableInfo tableInfo = new SimpleTableInfo();
        tableInfo.setTableName(this.tableName);
        tableInfo.setTableLabelName(this.tableLabelName);
        tableInfo.setTableComment(this.tableComment);
        tableInfo.setTableType(this.tableType);
        if (this.metadataJson != null && (columns = this.metadataJson.get("columns")) instanceof List) {
            for (Object col : (List)columns) {
                if (!(col instanceof Map)) continue;
                SimpleTableField column = new SimpleTableField();
                Map colMap = (Map)col;
                column.setColumnName(StringBaseOpt.castObjectToString(colMap.get("columnName")));
                column.setFieldLabelName(StringBaseOpt.castObjectToString(colMap.get("fieldLabelName")));
                column.setColumnComment(StringBaseOpt.castObjectToString(colMap.get("columnComment")));
                column.setMandatory(BooleanBaseOpt.castObjectToBoolean(colMap.get("mandatory"), (Boolean)false).booleanValue());
                column.setFieldType(StringBaseOpt.castObjectToString(colMap.get("fieldType")));
                column.setColumnType(FieldType.mapToDatabaseType((String)column.getFieldType(), (DBType)dt));
                column.setMaxLength(NumberBaseOpt.castObjectToInteger(colMap.get("maxLength"), (Integer)0).intValue());
                column.setPrimaryKey(BooleanBaseOpt.castObjectToBoolean(colMap.get("primaryKey"), (Boolean)false).booleanValue());
                column.setScale(NumberBaseOpt.castObjectToInteger(colMap.get("scale"), (Integer)0));
                column.setPrecision(NumberBaseOpt.castObjectToInteger(colMap.get("precision"), (Integer)0));
                if (!StringUtils.isNotBlank((CharSequence)column.getColumnName())) continue;
                tableInfo.addColumn(column);
            }
        }
        return tableInfo;
    }

    @JSONField(deserialize=false)
    @ApiModelProperty(hidden=true)
    public void setTableColumns(Collection<SimpleTableField> columns) {
        if (this.metadataJson == null) {
            this.metadataJson = new JSONObject();
        }
        this.metadataJson.put((Object)"columns", JSON.toJSON(columns));
    }

    public JSONObject toTableJson() {
        JSONObject jt = this.getMetadataJson();
        if (jt == null) {
            jt = new JSONObject();
        }
        JSONObject tableInfo = new JSONObject();
        tableInfo.put((Object)"tableId", (Object)this.getTableId());
        tableInfo.put((Object)"tableType", (Object)this.getTableType());
        tableInfo.put((Object)"tableName", (Object)this.getTableName());
        tableInfo.put((Object)"tableLabelName", (Object)this.getTableLabelName());
        tableInfo.put((Object)"tableComment", (Object)this.getTableComment());
        jt.put((Object)"tableInfo", (Object)tableInfo);
        return jt;
    }

    public static TableStruct formTableJson(JSONObject jt) {
        TableStruct ts = new TableStruct();
        JSONObject tableInfo = jt.getJSONObject("tableInfo");
        if (tableInfo != null) {
            ts.setTableId(tableInfo.getString("tableId"));
            ts.setTableType(tableInfo.getString("tableType"));
            ts.setTableName(tableInfo.getString("tableName"));
            ts.setTableLabelName(tableInfo.getString("tableLabelName"));
            ts.setTableComment(tableInfo.getString("tableComment"));
        }
        JSONObject metadataJson = new JSONObject();
        metadataJson.put((Object)"columns", jt.get("columns"));
        metadataJson.put((Object)"indexes", jt.get("indexes"));
        metadataJson.put((Object)"viewSql", jt.get("viewSql"));
        ts.setMetadataJson(metadataJson);
        return ts;
    }

    public String buildCreateTableSql(DBType dbType) {
        try {
            StringBuilder sqlBuilder = new StringBuilder();
            if ("V".equals(this.getTableType())) {
                sqlBuilder.append("create view ").append(this.getTableName()).append(" as \r\n  ").append(this.extraViewSql()).append(";");
            } else {
                sqlBuilder.append(GeneralDDLOperations.createDDLOperations((DBType)dbType).makeCreateTableSql((TableInfo)this.toTableInfo(dbType), true)).append(";");
                List<TableIndexInfo> indexes = this.fetchIndexes();
                if (indexes != null && indexes.size() > 0) {
                    for (TableIndexInfo ind : indexes) {
                        sqlBuilder.append("\r\n").append(ind.buildCreateIndexSql(this.getTableName(), dbType)).append(";");
                    }
                }
            }
            return sqlBuilder.toString();
        }
        catch (SQLException sqlExp) {
            return "/** \u521b\u5efa\u8868\uff1a" + this.getTableLabelName() + "(" + this.getTableName() + ")\u65f6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + sqlExp.getMessage() + "*/";
        }
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableLabelName() {
        return this.tableLabelName;
    }

    public void setTableLabelName(String tableLabelName) {
        this.tableLabelName = tableLabelName;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    public String getCreatorCode() {
        return this.creatorCode;
    }

    public void setCreatorCode(String creatorCode) {
        this.creatorCode = creatorCode;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Date getLastUpdateTIme() {
        return this.lastUpdateTIme;
    }

    public void setLastUpdateTIme(Date lastUpdateTIme) {
        this.lastUpdateTIme = lastUpdateTIme;
    }

    public JSONObject getMetadataJson() {
        return this.metadataJson;
    }

    public void setMetadataJson(JSONObject metadataJson) {
        this.metadataJson = metadataJson;
    }

    public Long getViewTimes() {
        return this.viewTimes;
    }

    public void setViewTimes(Long viewTimes) {
        this.viewTimes = viewTimes;
    }
}

