/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.po;

import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.DBType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TableIndexInfo {
    String indexName;
    String indexType;
    String indexComment;
    List<String> indexFields;

    public String buildCreateIndexSql(String tableName, DBType dbType) {
        String it;
        StringBuilder sqlBuilder = new StringBuilder();
        switch (it = StringUtils.isBlank((CharSequence)this.indexType) ? "NORMAL" : this.indexType.toUpperCase()) {
            case "UNIQUE": {
                sqlBuilder.append("create unique index ").append(this.indexName).append(" on \r\n  ").append(tableName).append(" (").append(StringBaseOpt.objectToString(this.indexFields)).append(" )");
                break;
            }
            case "BITMAP": {
                if (dbType == DBType.Oracle) {
                    sqlBuilder.append("create bitmap index ").append(this.indexName).append(" on \r\n  ").append(tableName).append(" (").append(StringBaseOpt.objectToString(this.indexFields)).append(" )");
                    break;
                }
                sqlBuilder.append("-- \u4ec5Oracle \u652f\u6301 BITMAP \u7d22\u5f15");
                break;
            }
            case "HASH": {
                if (dbType == DBType.MySql) {
                    sqlBuilder.append("create index ").append(this.indexName).append(" using hash on \r\n  ").append(tableName).append(" (").append(StringBaseOpt.objectToString(this.indexFields)).append(" )");
                    break;
                }
                sqlBuilder.append("-- \u4ec5MySQL \u652f\u6301 HASH \u7d22\u5f15");
                break;
            }
            case "FULLTEXT": {
                if (dbType == DBType.MySql) {
                    sqlBuilder.append("create fulltext index ").append(this.indexName).append(" on \r\n  ").append(tableName).append(" (").append(StringBaseOpt.objectToString(this.indexFields)).append(" ) WITH PARSER ngram");
                    break;
                }
                sqlBuilder.append("-- \u4ec5MySQL \u652f\u6301 FULLTEXT \u7d22\u5f15");
                break;
            }
            default: {
                sqlBuilder.append("create index ").append(this.indexName).append(" on \r\n  ").append(tableName).append(" (").append(StringBaseOpt.objectToString(this.indexFields)).append(" )");
            }
        }
        return sqlBuilder.toString();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public String getIndexComment() {
        return this.indexComment;
    }

    public List<String> getIndexFields() {
        return this.indexFields;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public void setIndexComment(String indexComment) {
        this.indexComment = indexComment;
    }

    public void setIndexFields(List<String> indexFields) {
        this.indexFields = indexFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableIndexInfo)) {
            return false;
        }
        TableIndexInfo other = (TableIndexInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$indexType = this.getIndexType();
        String other$indexType = other.getIndexType();
        if (this$indexType == null ? other$indexType != null : !this$indexType.equals(other$indexType)) {
            return false;
        }
        String this$indexComment = this.getIndexComment();
        String other$indexComment = other.getIndexComment();
        if (this$indexComment == null ? other$indexComment != null : !this$indexComment.equals(other$indexComment)) {
            return false;
        }
        List<String> this$indexFields = this.getIndexFields();
        List<String> other$indexFields = other.getIndexFields();
        return !(this$indexFields == null ? other$indexFields != null : !((Object)this$indexFields).equals(other$indexFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableIndexInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $indexType = this.getIndexType();
        result = result * 59 + ($indexType == null ? 43 : $indexType.hashCode());
        String $indexComment = this.getIndexComment();
        result = result * 59 + ($indexComment == null ? 43 : $indexComment.hashCode());
        List<String> $indexFields = this.getIndexFields();
        result = result * 59 + ($indexFields == null ? 43 : ((Object)$indexFields).hashCode());
        return result;
    }

    public String toString() {
        return "TableIndexInfo(indexName=" + this.getIndexName() + ", indexType=" + this.getIndexType() + ", indexComment=" + this.getIndexComment() + ", indexFields=" + this.getIndexFields() + ")";
    }
}

