/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.po;

import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@ApiModel
@Entity
@Table(name="TS_PROJECT_INFO")
public class ProjectInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="PROJECT_ID")
    @ApiModelProperty(value="\u9879\u76eeID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String projectId;
    @Column(name="PROJECT_NAME")
    @ApiModelProperty(value="\u9879\u76ee\u540d\u79f0")
    private String projectName;
    @Column(name="FORK_PROJECT_ID")
    @ApiModelProperty(value="FORK\u9879\u76eeID, \u81ea\u521b\u7684\u4e3a\u7a7a")
    private String forkProject;
    @Column(name="INDUSTRY_CATEGORY")
    @ApiModelProperty(value="\u884c\u4e1a\u7c7b\u522b")
    private String industryCategory;
    @Column(name="PROJECT_DESC")
    @ApiModelProperty(value="\u9879\u76ee\u63cf\u8ff0")
    private String projectDesc;
    @Column(name="CREATOR_CODE")
    @ApiModelProperty(value="\u9879\u76ee\u521b\u5efa\u4eba")
    private String creatorCode;
    @Column(name="CREATOR_NAME")
    @ApiModelProperty(value="\u521b\u5efa\u4eba\u59d3\u540d")
    private String creatorName;
    @Column(name="LAST_UPDATE_TIME")
    @ApiModelProperty(value="\u6700\u540e\u66f4\u65b0\u65f6\u95f4")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, condition=GeneratorCondition.ALWAYS, value="today()")
    private Date lastUpdateTIme;
    @Column(name="FOLLOWED_SUM")
    @ApiModelProperty(value="\u9879\u76ee\u88ab\u5173\u6ce8\u7684\u6570\u91cf")
    private long followedSum;
    @Column(name="TABLE_FORKED_TIMES")
    @ApiModelProperty(value="\u8868\u88abfork\u6b21\u6570")
    private long tableForkedTimes;
    @Column(name="PROJECT_FORKED_TIMES")
    @ApiModelProperty(value="\u9879\u76ee\u88abfork\u6b21\u6570")
    private long projectForkedTimes;
    @Column(name="TABLE_VIEWED_TIMES")
    @ApiModelProperty(value="\u8868\u88ab\u67e5\u770b\u6b21\u6570")
    private long tableViewedTimes;
    @Column(name="SORT_SCORE")
    @ApiModelProperty(value="\u6392\u5e8f\u6743\u91cd\u5f97\u5206")
    private long sortScore;

    public ProjectInfo() {
        this.clearSortScore();
    }

    public void clearSortScore() {
        this.tableForkedTimes = 0L;
        this.projectForkedTimes = 0L;
        this.tableViewedTimes = 0L;
        this.followedSum = 0L;
        this.sortScore = 0L;
    }

    public void calcSortScore() {
        this.sortScore = this.followedSum * 5L + this.projectForkedTimes * 10L + this.tableForkedTimes * 2L + this.tableViewedTimes;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getForkProject() {
        return this.forkProject;
    }

    public String getIndustryCategory() {
        return this.industryCategory;
    }

    public String getProjectDesc() {
        return this.projectDesc;
    }

    public String getCreatorCode() {
        return this.creatorCode;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public Date getLastUpdateTIme() {
        return this.lastUpdateTIme;
    }

    public long getFollowedSum() {
        return this.followedSum;
    }

    public long getTableForkedTimes() {
        return this.tableForkedTimes;
    }

    public long getProjectForkedTimes() {
        return this.projectForkedTimes;
    }

    public long getTableViewedTimes() {
        return this.tableViewedTimes;
    }

    public long getSortScore() {
        return this.sortScore;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setForkProject(String forkProject) {
        this.forkProject = forkProject;
    }

    public void setIndustryCategory(String industryCategory) {
        this.industryCategory = industryCategory;
    }

    public void setProjectDesc(String projectDesc) {
        this.projectDesc = projectDesc;
    }

    public void setCreatorCode(String creatorCode) {
        this.creatorCode = creatorCode;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setLastUpdateTIme(Date lastUpdateTIme) {
        this.lastUpdateTIme = lastUpdateTIme;
    }

    public void setFollowedSum(long followedSum) {
        this.followedSum = followedSum;
    }

    public void setTableForkedTimes(long tableForkedTimes) {
        this.tableForkedTimes = tableForkedTimes;
    }

    public void setProjectForkedTimes(long projectForkedTimes) {
        this.projectForkedTimes = projectForkedTimes;
    }

    public void setTableViewedTimes(long tableViewedTimes) {
        this.tableViewedTimes = tableViewedTimes;
    }

    public void setSortScore(long sortScore) {
        this.sortScore = sortScore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectInfo)) {
            return false;
        }
        ProjectInfo other = (ProjectInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$forkProject = this.getForkProject();
        String other$forkProject = other.getForkProject();
        if (this$forkProject == null ? other$forkProject != null : !this$forkProject.equals(other$forkProject)) {
            return false;
        }
        String this$industryCategory = this.getIndustryCategory();
        String other$industryCategory = other.getIndustryCategory();
        if (this$industryCategory == null ? other$industryCategory != null : !this$industryCategory.equals(other$industryCategory)) {
            return false;
        }
        String this$projectDesc = this.getProjectDesc();
        String other$projectDesc = other.getProjectDesc();
        if (this$projectDesc == null ? other$projectDesc != null : !this$projectDesc.equals(other$projectDesc)) {
            return false;
        }
        String this$creatorCode = this.getCreatorCode();
        String other$creatorCode = other.getCreatorCode();
        if (this$creatorCode == null ? other$creatorCode != null : !this$creatorCode.equals(other$creatorCode)) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        Date this$lastUpdateTIme = this.getLastUpdateTIme();
        Date other$lastUpdateTIme = other.getLastUpdateTIme();
        if (this$lastUpdateTIme == null ? other$lastUpdateTIme != null : !((Object)this$lastUpdateTIme).equals(other$lastUpdateTIme)) {
            return false;
        }
        if (this.getFollowedSum() != other.getFollowedSum()) {
            return false;
        }
        if (this.getTableForkedTimes() != other.getTableForkedTimes()) {
            return false;
        }
        if (this.getProjectForkedTimes() != other.getProjectForkedTimes()) {
            return false;
        }
        if (this.getTableViewedTimes() != other.getTableViewedTimes()) {
            return false;
        }
        return this.getSortScore() == other.getSortScore();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $forkProject = this.getForkProject();
        result = result * 59 + ($forkProject == null ? 43 : $forkProject.hashCode());
        String $industryCategory = this.getIndustryCategory();
        result = result * 59 + ($industryCategory == null ? 43 : $industryCategory.hashCode());
        String $projectDesc = this.getProjectDesc();
        result = result * 59 + ($projectDesc == null ? 43 : $projectDesc.hashCode());
        String $creatorCode = this.getCreatorCode();
        result = result * 59 + ($creatorCode == null ? 43 : $creatorCode.hashCode());
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        Date $lastUpdateTIme = this.getLastUpdateTIme();
        result = result * 59 + ($lastUpdateTIme == null ? 43 : ((Object)$lastUpdateTIme).hashCode());
        long $followedSum = this.getFollowedSum();
        result = result * 59 + (int)($followedSum >>> 32 ^ $followedSum);
        long $tableForkedTimes = this.getTableForkedTimes();
        result = result * 59 + (int)($tableForkedTimes >>> 32 ^ $tableForkedTimes);
        long $projectForkedTimes = this.getProjectForkedTimes();
        result = result * 59 + (int)($projectForkedTimes >>> 32 ^ $projectForkedTimes);
        long $tableViewedTimes = this.getTableViewedTimes();
        result = result * 59 + (int)($tableViewedTimes >>> 32 ^ $tableViewedTimes);
        long $sortScore = this.getSortScore();
        result = result * 59 + (int)($sortScore >>> 32 ^ $sortScore);
        return result;
    }

    public String toString() {
        return "ProjectInfo(projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", forkProject=" + this.getForkProject() + ", industryCategory=" + this.getIndustryCategory() + ", projectDesc=" + this.getProjectDesc() + ", creatorCode=" + this.getCreatorCode() + ", creatorName=" + this.getCreatorName() + ", lastUpdateTIme=" + this.getLastUpdateTIme() + ", followedSum=" + this.getFollowedSum() + ", tableForkedTimes=" + this.getTableForkedTimes() + ", projectForkedTimes=" + this.getProjectForkedTimes() + ", tableViewedTimes=" + this.getTableViewedTimes() + ", sortScore=" + this.getSortScore() + ")";
    }
}

