/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.po;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.tablestore.po.ProjectFollowerId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

@ApiModel
@Entity
@Table(name="TS_PROJECT_FOLLOWER")
public class ProjectFollower
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    ProjectFollowerId pfId;
    @Column(name="FOLLOWER_NAME")
    @ApiModelProperty(value="\u5173\u6ce8\u4eba\u5458\u59d3\u540d")
    private String followerName;
    @Column(name="FOLLOWER_CATALOG")
    @ApiModelProperty(value="\u5173\u6ce8\u7c7b\u522b\uff0c\u8fd9\u4e2a\u6682\u65f6\u53ef\u4ee5\u7a7a\u7740")
    private String followerCatalog;
    @Column(name="CREATE_TIME")
    @ApiModelProperty(value="\u521b\u5efa\u65f6\u95f4")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    private Date createTIme;

    public ProjectFollower() {
    }

    public ProjectFollower(String projectId, String userCode) {
        this.pfId = new ProjectFollowerId(projectId, userCode);
        this.createTIme = DatetimeOpt.currentUtilDate();
    }

    public String getProjectId() {
        if (this.pfId == null) {
            return null;
        }
        return this.pfId.getProjectId();
    }

    public void setProjectId(String projectId) {
        if (this.pfId == null) {
            this.pfId = new ProjectFollowerId();
        }
        this.pfId.setProjectId(projectId);
    }

    public String getProjectFollower() {
        if (this.pfId == null) {
            return null;
        }
        return this.pfId.getProjectFollower();
    }

    public void setProjectFollower(String projectFollower) {
        if (this.pfId == null) {
            this.pfId = new ProjectFollowerId();
        }
        this.pfId.setProjectFollower(projectFollower);
    }

    public ProjectFollowerId getPfId() {
        return this.pfId;
    }

    public String getFollowerName() {
        return this.followerName;
    }

    public String getFollowerCatalog() {
        return this.followerCatalog;
    }

    public Date getCreateTIme() {
        return this.createTIme;
    }

    public void setPfId(ProjectFollowerId pfId) {
        this.pfId = pfId;
    }

    public void setFollowerName(String followerName) {
        this.followerName = followerName;
    }

    public void setFollowerCatalog(String followerCatalog) {
        this.followerCatalog = followerCatalog;
    }

    public void setCreateTIme(Date createTIme) {
        this.createTIme = createTIme;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectFollower)) {
            return false;
        }
        ProjectFollower other = (ProjectFollower)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProjectFollowerId this$pfId = this.getPfId();
        ProjectFollowerId other$pfId = other.getPfId();
        if (this$pfId == null ? other$pfId != null : !((Object)this$pfId).equals(other$pfId)) {
            return false;
        }
        String this$followerName = this.getFollowerName();
        String other$followerName = other.getFollowerName();
        if (this$followerName == null ? other$followerName != null : !this$followerName.equals(other$followerName)) {
            return false;
        }
        String this$followerCatalog = this.getFollowerCatalog();
        String other$followerCatalog = other.getFollowerCatalog();
        if (this$followerCatalog == null ? other$followerCatalog != null : !this$followerCatalog.equals(other$followerCatalog)) {
            return false;
        }
        Date this$createTIme = this.getCreateTIme();
        Date other$createTIme = other.getCreateTIme();
        return !(this$createTIme == null ? other$createTIme != null : !((Object)this$createTIme).equals(other$createTIme));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectFollower;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProjectFollowerId $pfId = this.getPfId();
        result = result * 59 + ($pfId == null ? 43 : ((Object)$pfId).hashCode());
        String $followerName = this.getFollowerName();
        result = result * 59 + ($followerName == null ? 43 : $followerName.hashCode());
        String $followerCatalog = this.getFollowerCatalog();
        result = result * 59 + ($followerCatalog == null ? 43 : $followerCatalog.hashCode());
        Date $createTIme = this.getCreateTIme();
        result = result * 59 + ($createTIme == null ? 43 : ((Object)$createTIme).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectFollower(pfId=" + this.getPfId() + ", followerName=" + this.getFollowerName() + ", followerCatalog=" + this.getFollowerCatalog() + ", createTIme=" + this.getCreateTIme() + ")";
    }
}

