/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.dao;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.TableStruct;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

@Repository
public class TableStructDao
extends BaseDaoImpl<TableStruct, String> {
    public Map<String, String> getFilterField() {
        return null;
    }

    public boolean isTableExist(String projectId, String tableName) {
        String sql = " SELECT COUNT(1) FROM TS_TABLE_STRUCT WHERE PROJECT_ID = ? and LOWER(TABLE_NAME) = ? ";
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)sql, (Object[])new Object[]{projectId, tableName.toLowerCase()})) > 0;
    }

    public JSONArray statTables(String keyWords) {
        return DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)"select a.INDUSTRY_CATEGORY, count(1) as TABLE_SUM from TS_PROJECT_INFO a join TS_TABLE_STRUCT b on a.PROJECT_ID=b.PROJECT_ID where match(FULLTEXT_INDEX) against(?) group by a.INDUSTRY_CATEGORY", (Object[])new Object[]{keyWords});
    }

    public JSONArray searchTables(String keyWords, String industryCategory, PageDesc pageDesc) {
        int returnObject;
        int offset = pageDesc.getRowStart();
        int maxsize = pageDesc.getPageSize();
        String sql = "select b.TABLE_ID, b.PROJECT_ID, a.PROJECT_NAME, b.TABLE_TYPE, b.TABLE_NAME, b.TABLE_LABEL_NAME, b.TABLE_COMMENT, b.CREATOR_CODE, b.CREATOR_NAME, b.LAST_UPDATE_TIME from TS_PROJECT_INFO a join TS_TABLE_STRUCT b on a.PROJECT_ID=b.PROJECT_ID where match(FULLTEXT_INDEX) against(?) ";
        String limitSql = offset > 0 ? " limit " + offset + "," + maxsize : " limit " + maxsize;
        String orderBySql = " order by a.SORT_SCORE desc ";
        JSONArray jsonArray = null;
        jsonArray = StringUtils.isBlank((CharSequence)industryCategory) ? DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)(sql + orderBySql + limitSql), (Object[])new Object[]{keyWords}) : DatabaseOptUtils.listObjectsBySqlAsJson((BaseDaoImpl)this, (String)(sql + " and a.INDUSTRY_CATEGORY = ?" + orderBySql + limitSql), (Object[])new Object[]{keyWords, industryCategory});
        int n = returnObject = jsonArray == null ? 0 : jsonArray.size();
        if (returnObject < maxsize) {
            pageDesc.setTotalRows(Integer.valueOf(offset + returnObject));
        } else if (offset + returnObject + 1 > pageDesc.getTotalRows()) {
            pageDesc.setTotalRows(Integer.valueOf(offset + returnObject + 1));
        }
        return jsonArray;
    }

    public void deleteProjectTable(String projectId) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}));
    }

    public TableStruct getTableByName(String projectId, String tableName) {
        Pair querySql = GeneralJsonObjectDao.buildSelectSqlWithFields((TableInfo)JpaMetadata.fetchTableMapInfo((Class)this.getPoClass()), null, (boolean)false, (String)"PROJECT_ID = ? and LOWER(TABLE_NAME) = ?", (boolean)false, null);
        List tables = this.listObjectsBySql((String)querySql.getLeft(), new Object[]{projectId, tableName.toLowerCase()});
        if (tables == null || tables.size() < 1) {
            return null;
        }
        return (TableStruct)tables.get(0);
    }

    public List<TableStruct> listProjectTableWithColumn(String projectId) {
        Pair querySql = GeneralJsonObjectDao.buildSelectSqlWithFields((TableInfo)JpaMetadata.fetchTableMapInfo((Class)this.getPoClass()), null, (boolean)false, (String)"PROJECT_ID = ?", (boolean)false, null);
        return this.listObjectsBySql((String)querySql.getLeft(), new Object[]{projectId});
    }

    public List<TableStruct> listTablesByIds(List<String> tableIds) {
        Pair querySql = GeneralJsonObjectDao.buildSelectSqlWithFields((TableInfo)JpaMetadata.fetchTableMapInfo((Class)this.getPoClass()), null, (boolean)false, (String)"TABLE_ID in (:ids)", (boolean)false, null);
        return this.listObjectsBySql((String)querySql.getLeft(), CollectionsOpt.createHashMap((Object[])new Object[]{"ids", tableIds}));
    }

    public TableStruct mergeTable(TableStruct ts, String projectId) {
        TableStruct dbTS = this.getTableByName(projectId, ts.getTableName());
        if (dbTS != null) {
            dbTS.setTableLabelName(ts.getTableLabelName());
            dbTS.setTableComment(ts.getTableComment());
            dbTS.setTableType(ts.getTableType());
            dbTS.setMetadataJson(ts.getMetadataJson());
            this.updateObject(dbTS);
            return dbTS;
        }
        ts.setProjectId(projectId);
        this.saveNewObject(ts);
        return ts;
    }
}

