/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.tablestore.po.ProjectModule;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

@Repository
public class ProjectModuleDao
extends BaseDaoImpl<ProjectModule, String> {
    public Map<String, String> getFilterField() {
        return null;
    }

    public void deleteProjectModule(String projectId) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"projectId", projectId}));
    }

    public List<ProjectModule> listProjectModuleWithDesign(String projectId) {
        Pair querySql = GeneralJsonObjectDao.buildSelectSqlWithFields((TableInfo)JpaMetadata.fetchTableMapInfo((Class)this.getPoClass()), null, (boolean)false, (String)"PROJECT_ID = ? ", (boolean)false, null);
        return this.listObjectsBySql((String)querySql.getLeft(), new Object[]{projectId});
    }

    public ProjectModule getModuleByName(String projectId, String moduleName) {
        Pair querySql = GeneralJsonObjectDao.buildSelectSqlWithFields((TableInfo)JpaMetadata.fetchTableMapInfo((Class)this.getPoClass()), null, (boolean)false, (String)"PROJECT_ID = ? and MODULE_NAME = ?", (boolean)false, null);
        List modules = this.listObjectsBySql((String)querySql.getLeft(), new Object[]{projectId, moduleName});
        if (modules == null || modules.size() < 1) {
            return null;
        }
        return (ProjectModule)modules.get(0);
    }

    public ProjectModule mergeProjectModule(ProjectModule projectModule) {
        ProjectModule dbMD = this.getModuleByName(projectModule.getProjectId(), projectModule.getModuleName());
        if (dbMD != null) {
            dbMD.setModuleDesign(projectModule.getModuleDesign());
            dbMD.setModuleDesc(projectModule.getModuleDesc());
            this.updateObject(dbMD);
            return dbMD;
        }
        this.saveNewObject(projectModule);
        return projectModule;
    }
}

