/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import com.centit.tablestore.po.ProjectFollower;
import com.centit.tablestore.po.ProjectInfo;
import com.centit.tablestore.po.ProjectTeam;
import com.centit.tablestore.po.TableStruct;
import com.centit.tablestore.service.ProjectHistoryService;
import com.centit.tablestore.service.ProjectInfoService;
import com.centit.tablestore.service.impl.PdmTableInfoUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u9879\u76ee\u7ef4\u62a4\u63a5\u53e3", tags={"\u9879\u76ee\u7ef4\u62a4\u63a5\u53e3"})
@RestController
@RequestMapping(value={"project"})
public class ProjectController
extends BaseController {
    @Autowired
    protected ProjectInfoService projectInfoService;
    @Autowired
    private ProjectHistoryService projectHistoryService;

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u6709\u9879\u76ee", notes="\u83b7\u53d6\u7528\u6237\u6240\u6709\u9879\u76ee")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801\uff0c\u7f3a\u7701\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4ee3\u7801", paramType="query")
    @GetMapping(value={"/stat"})
    @WrapUpResponseBody
    public Map<String, Object> calcUserStatInfo(HttpServletRequest request) {
        String userCode = request.getParameter("userCode");
        if (StringUtils.isBlank((CharSequence)userCode)) {
            userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        }
        return this.projectInfoService.getUserStatInfo(userCode);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u6709\u9879\u76ee", notes="\u83b7\u53d6\u7528\u6237\u6240\u6709\u9879\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class), @ApiImplicitParam(name="onlyCreated", value="\u4ec5\u4ec5\u8fd4\u56de\u7528\u6237\u521b\u5efa\u7684\u9879\u76ee", paramType="query"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801\uff0c\u7f3a\u7701\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4ee3\u7801", paramType="query")})
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<Object> list(PageDesc pageDesc, String onlyCreated, HttpServletRequest request) {
        String userCode = request.getParameter("userCode");
        if (StringUtils.isBlank((CharSequence)userCode)) {
            userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        }
        JSONArray projectInfos = BooleanBaseOpt.castObjectToBoolean((Object)onlyCreated, (Boolean)false) != false ? this.projectInfoService.listUserCreateProjects(userCode, pageDesc) : this.projectInfoService.listUserProjects(userCode, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)projectInfos, (PageDesc)pageDesc, (Class[])new Class[]{ProjectInfo.class});
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5173\u6ce8\u7684\u9879\u76ee", notes="\u83b7\u53d6\u7528\u6237\u5173\u6ce8\u7684\u9879\u76ee")
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\uff0c\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @GetMapping(value={"/followed"})
    @WrapUpResponseBody
    public PageQueryResult<Object> followedProjects(PageDesc pageDesc, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(611, "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u53ea\u6709\u767b\u5f55\u7684\u7528\u6237\u53ef\u4ee5\u83b7\u53d6\u5230\u4ed6\u5173\u6ce8\u7684\u9879\u76ee\u3002");
        }
        JSONArray projectInfos = this.projectInfoService.listFollowerProjects(userCode, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)projectInfos, (PageDesc)pageDesc, (Class[])new Class[]{ProjectInfo.class});
    }

    @ApiOperation(value="\u6dfb\u52a0\u5173\u6ce8\u9879\u76ee")
    @PostMapping(value={"/followed"})
    @WrapUpResponseBody
    public void addFollowedProject(@RequestBody ProjectFollower follower, HttpServletRequest request) {
        CentitUserDetails userDetails = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (userDetails == null) {
            throw new ObjectException(611, "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u53ea\u6709\u767b\u5f55\u7684\u7528\u6237\u53ef\u4ee5\u6dfb\u52a0\u5173\u6ce8\u7684\u9879\u76ee\u3002");
        }
        if (StringUtils.isBlank((CharSequence)follower.getProjectId())) {
            throw new ObjectException(611, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9879\u76ee\u4ee3\u7801ProjectId\u3002");
        }
        follower.setProjectFollower(userDetails.getUserCode());
        follower.setFollowerName(userDetails.getUserInfo().getString("userName"));
        this.projectInfoService.addFollowerProject(follower);
    }

    @ApiOperation(value="\u5220\u9664\u5173\u6ce8\u9879\u76ee")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @DeleteMapping(value={"/followed/{projectId}"})
    @WrapUpResponseBody
    public void deleteFollowedProject(@PathVariable String projectId, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(611, "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u53ea\u6709\u767b\u5f55\u7684\u7528\u6237\u53ef\u4ee5\u53d6\u6d88\u4ed6\u7684\u5173\u6ce8\u9879\u76ee\u3002");
        }
        this.projectInfoService.deleteFollowerProject(userCode, projectId);
    }

    @ApiOperation(value="\u662f\u5426\u5df2\u7ecf\u5173\u6ce8\u9879\u76ee")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @GetMapping(value={"/followed/{projectId}"})
    @WrapUpResponseBody
    public boolean hasFollowedProject(@PathVariable String projectId, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(611, "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u53ea\u6709\u767b\u5f55\u7684\u7528\u6237\u53ef\u4ee5\u68c0\u6d4b\u662f\u5426\u5173\u6ce8\u9879\u76ee\u3002");
        }
        return this.projectInfoService.hasFollowedProject(projectId, userCode);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u9879\u76ee")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @GetMapping(value={"/{projectId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public ProjectInfo getProjectInfo(@PathVariable String projectId) {
        return this.projectInfoService.getProjectInfo(projectId);
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u9879\u76ee")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @DeleteMapping(value={"/{projectId}"})
    @WrapUpResponseBody
    public void deleteProjectInfo(@PathVariable String projectId) {
        this.projectInfoService.deleteProjectInfo(projectId);
    }

    @ApiOperation(value="\u65b0\u5efa\u9879\u76ee\u6570\u636e")
    @PostMapping
    @WrapUpResponseBody
    public ProjectInfo saveProjectInfo(@RequestBody ProjectInfo projectInfo, HttpServletRequest request) {
        CentitUserDetails ud = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (ud == null) {
            throw new ObjectException(403, "Session\u8fc7\u671f\u6216\u8005\u7528\u6237\u6ca1\u6709\u767b\u5f55\u3002");
        }
        projectInfo.setCreatorCode(ud.getUserCode());
        projectInfo.setCreatorName(ud.getUserInfo().getString("userName"));
        this.projectInfoService.createNewProject(projectInfo);
        return projectInfo;
    }

    @ApiOperation(value="\u4fee\u6539\u9879\u76ee\u6570\u636e")
    @PutMapping
    @WrapUpResponseBody
    public void updateProjectInfo(@RequestBody ProjectInfo projectInfo) {
        this.projectInfoService.updateProjectInfo(projectInfo);
    }

    @ApiOperation(value="\u751f\u6210\u811a\u672c", notes="\u751f\u6210\u811a\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID"), @ApiImplicitParam(name="dbtype", type="query", value="\u6570\u636e\u7c7b\u522b")})
    @GetMapping(value={"/sql/{projectId}"})
    @WrapUpResponseBody
    public String createSql(@PathVariable String projectId, String dbtype) {
        return this.projectInfoService.makeCreateSql(projectId, DBType.mapDBType((String)dbtype, (DBType)DBType.MySql));
    }

    @ApiOperation(value="DDL\u811a\u672c\u4ee5\u6587\u4ef6\u65b9\u5f0f\u8fd4\u56de", notes="DDL\u811a\u672c\u4ee5\u6587\u4ef6\u65b9\u5f0f\u8fd4\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID"), @ApiImplicitParam(name="dbtype", type="query", value="\u6570\u636e\u7c7b\u522b")})
    @GetMapping(value={"/ddl/{projectId}"})
    public void downloadDDL(@PathVariable String projectId, String dbtype, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ProjectInfo projectInfo = this.projectInfoService.getProjectInfo(projectId);
        if (projectInfo == null) {
            throw new ObjectException(604, "\u9879\u76ee\uff1a" + projectId + " \u4e0d\u5b58\u5728\uff01");
        }
        String ddl = this.projectInfoService.makeCreateSql(projectId, DBType.mapDBType((String)dbtype, (DBType)DBType.MySql));
        String fileName = projectInfo.getProjectName() + ".sql";
        ByteArrayInputStream bis = new ByteArrayInputStream(ddl.getBytes(StandardCharsets.UTF_8));
        UploadDownloadUtils.downloadFile((InputStream)bis, (String)fileName, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9879\u76ee\u7684\u8868\u7ed3\u6784\u4fe1\u606f", notes="\u5bfc\u51fa\u9879\u76ee\u7684\u8868\u7ed3\u6784\u4fe1\u606f")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @GetMapping(value={"/export/{projectId}"})
    public void exportProject(@PathVariable String projectId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ProjectInfo projectInfo = this.projectInfoService.getProjectInfo(projectId);
        if (projectInfo == null) {
            throw new ObjectException(604, "\u9879\u76ee\uff1a" + projectId + " \u4e0d\u5b58\u5728\uff01");
        }
        JSONObject json = this.projectInfoService.exportProject(projectId);
        String fileName = projectInfo.getProjectName() + ".json";
        ByteArrayInputStream bis = new ByteArrayInputStream(json.toJSONString(new JSONWriter.Feature[0]).getBytes(StandardCharsets.UTF_8));
        UploadDownloadUtils.downloadFile((InputStream)bis, (String)fileName, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    @ApiOperation(value="fork\u9879\u76ee\u6570\u636e")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @PostMapping(value={"/fork/{projectId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public ProjectInfo forkProjectInfo(@PathVariable String projectId, HttpServletRequest request) {
        CentitUserDetails ud = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (ud == null) {
            throw new ObjectException(403, "Session\u8fc7\u671f\u6216\u8005\u7528\u6237\u6ca1\u6709\u767b\u5f55\u3002");
        }
        return this.projectInfoService.forkProject(ud, projectId);
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u534f\u4f5c\u4eba\u5458")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @GetMapping(value={"/member/{projectId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public List<ProjectTeam> listProjectMember(@PathVariable String projectId, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        return this.projectInfoService.listProjectMember(userCode, projectId);
    }

    @ApiOperation(value="\u68c0\u67e5\u81ea\u5df1\u662f\u5426\u53ef\u4ee5\u7f16\u8f91\u9879\u76ee")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @GetMapping(value={"/canedit/{projectId}"})
    @WrapUpResponseBody
    public boolean canEditProject(@PathVariable String projectId, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        return this.projectInfoService.checkMember(projectId, userCode);
    }

    @ApiOperation(value="\u6dfb\u52a0\u9879\u76ee\u534f\u4f5c\u4eba\u5458")
    @PostMapping(value={"/member"})
    @WrapUpResponseBody
    public void addProjectMember(@RequestBody String projectMembers, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        JSONObject projMembers = JSONObject.parseObject((String)projectMembers);
        String projectId = projMembers.getString("projectId");
        Object members = projMembers.get("projectMember");
        if (members == null) {
            members = projMembers.get("projectMembers");
        }
        if (StringUtils.isBlank((CharSequence)userCode) || StringUtils.isBlank((CharSequence)projectId) || members == null) {
            throw new ObjectException(611, "\u8868\u5355\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6216\u8005\u7528\u6237\u6ca1\u6709\u767b\u5f55\u3002");
        }
        List memeberCodes = StringBaseOpt.objectToStringList((Object)members);
        for (String mc : memeberCodes) {
            this.projectInfoService.addProjectMember(userCode, projectId, mc);
        }
    }

    @ApiOperation(value="\u5220\u9664\u9879\u76ee\u534f\u4f5c\u4eba\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID"), @ApiImplicitParam(name="memberCode", type="path", value="\u534f\u4f5c\u4eba\u5458\u4ee3\u7801")})
    @DeleteMapping(value={"/delete/{projectId}/{memberCode}"})
    @WrapUpResponseBody
    public void deleteProjectMember(@PathVariable String projectId, @PathVariable String memberCode, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        this.projectInfoService.deleteProjectMember(userCode, projectId, memberCode);
    }

    @ApiOperation(value="\u5220\u9664\u9879\u76ee\u534f\u4f5c\u4eba\u5458,post\u65b9\u6cd5\uff0c\u53ef\u4ee5\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteMembers"})
    @WrapUpResponseBody
    public void deleteProjectMember(@RequestBody String projectMembers, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        JSONObject projMembers = JSONObject.parseObject((String)projectMembers);
        String projectId = projMembers.getString("projectId");
        Object members = projMembers.get("projectMember");
        if (members == null) {
            members = projMembers.get("projectMembers");
        }
        if (StringUtils.isBlank((CharSequence)userCode) || StringUtils.isBlank((CharSequence)projectId) || members == null) {
            throw new ObjectException(611, "\u8868\u5355\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6216\u8005\u7528\u6237\u6ca1\u6709\u767b\u5f55\u3002");
        }
        List memeberCodes = StringBaseOpt.objectToStringList((Object)members);
        for (String mc : memeberCodes) {
            this.projectInfoService.deleteProjectMember(userCode, projectId, mc);
        }
    }

    @ApiOperation(value="\u68c0\u67e5\u6587\u4ef6\u5b8c\u6574\u6027")
    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.GET})
    @RequestMapping(value={"/range"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public JSONObject checkFileRange(String token, long size) {
        String tempFilePath = SystemTempFileUtils.getTempFilePath((String)token, (long)size);
        long tempFileSize = SystemTempFileUtils.checkTempFileSize((String)tempFilePath);
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("tempFilePath", token + "_" + size);
        JSONObject jsonObject = UploadDownloadUtils.makeRangeUploadJson((long)tempFileSize, (String)token, (String)(token + "_" + size));
        if (tempFileSize == size) {
            data.put("tables", PdmTableInfoUtils.importTableFromPdm(tempFilePath));
            jsonObject.put((Object)"tables", data);
        }
        return jsonObject;
    }

    @ApiOperation(value="\u5bfc\u5165pdm\u8fd4\u56de\u8868\u6570\u636e")
    @CrossOrigin(origins={"*"}, allowCredentials="true", maxAge=86400L, methods={RequestMethod.POST})
    @RequestMapping(value={"/range"}, method={RequestMethod.POST})
    public void syncPdm(String token, long size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair fileInfo = UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request);
        FileSystemOpt.createDirect((String)SystemTempFileUtils.getTempDirectory());
        String tempFilePath = SystemTempFileUtils.getTempFilePath((String)token, (long)size);
        try (FileOutputStream out = new FileOutputStream(new File(tempFilePath));){
            long uploadSize = FileIOOpt.writeInputStreamToOutputStream((InputStream)((InputStream)fileInfo.getRight()), (OutputStream)out);
            if (uploadSize > 0L) {
                JSONObject jsonObject = new JSONObject();
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                data.put("tempFilePath", token + "_" + size);
                data.put("tables", PdmTableInfoUtils.getTableNameFromPdm(tempFilePath));
                jsonObject.put((Object)"tables", data);
                JsonResultUtils.writeSingleDataJson((Object)jsonObject, (HttpServletResponse)response);
            } else {
                JsonResultUtils.writeOriginalJson((String)UploadDownloadUtils.makeRangeUploadJson((long)uploadSize, (String)token, (String)(token + "_" + size)).toJSONString(new JSONWriter.Feature[0]), (HttpServletResponse)response);
            }
        }
        catch (ObjectException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            JsonResultUtils.writeHttpErrorMessage((int)e.getExceptionCode(), (String)e.getMessage(), (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u786e\u8ba4\u5bfc\u5165pdm\u4fee\u6539\u8868\u5143\u6570\u636e\u8868")
    @RequestMapping(value={"/confirm/{projectId}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public void importPdmConfirm(@PathVariable String projectId, @RequestBody String data, HttpServletRequest request) {
        CentitUserDetails ud = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (ud == null) {
            throw new ObjectException(403, "Session\u8fc7\u671f\u6216\u8005\u7528\u6237\u6ca1\u6709\u767b\u5f55\u3002");
        }
        Map params = ProjectController.collectRequestParameters((HttpServletRequest)request);
        JSONObject object = JSON.parseObject((String)data);
        object.putAll(params);
        String tempFilePath = SystemTempFileUtils.getTempDirectory() + object.getString("tempFilePath") + ".tmp";
        JSONArray jsonArray = object.getJSONArray("data");
        ArrayList<String> tables = new ArrayList<String>();
        for (Object o : jsonArray) {
            tables.add(o.toString());
        }
        List<TableStruct> tableStructs = PdmTableInfoUtils.importTableFromPdm(tempFilePath, tables);
        this.projectInfoService.mergeProjectTables(projectId, ud, tableStructs);
    }

    @ApiOperation(value="\u5bfc\u5165TableStore\u4e2d\u5bfc\u5165\u8868\u7ed3\u6784")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @RequestMapping(value={"/imoprt/{projectId}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public void importFromTableStore(@PathVariable String projectId, HttpServletRequest request) throws IOException {
        Pair fileInfo = UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request);
        JSONObject jsonObject = JSON.parseObject((InputStream)((InputStream)fileInfo.getRight()), (JSONReader.Feature[])new JSONReader.Feature[0]);
        if (!(jsonObject != null && jsonObject.containsKey("projectInfo") && jsonObject.containsKey("tables") && jsonObject.containsKey("modules"))) {
            throw new ObjectException(611, "\u6587\u4ef6\u4e2d\u7684json\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        this.projectHistoryService.mergeProject(projectId, jsonObject);
    }
}

