/*
 * Decompiled with CFR 0.152.
 */
package com.centit.tablestore.controller;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.DBType;
import com.centit.tablestore.po.ProjectModule;
import com.centit.tablestore.po.TableStruct;
import com.centit.tablestore.service.ProjectModuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6a21\u5757\u7ef4\u62a4\u63a5\u53e3", tags={"\u6a21\u5757\u7ef4\u62a4\u63a5\u53e3"})
@RestController
@RequestMapping(value={"module"})
public class ModuleController
extends BaseController {
    @Autowired
    protected ProjectModuleService projectModuleService;

    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u6240\u6709\u6a21\u5757", notes="\u83b7\u53d6\u9879\u76ee\u6240\u6709\u6a21\u5757\u4e0d\u5206\u9875")
    @ApiImplicitParam(name="projectId", type="path", value="\u9879\u76eeID")
    @GetMapping(value={"/list/{projectId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public List<ProjectModule> list(@PathVariable String projectId) {
        return this.projectModuleService.listProjectModules(projectId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6a21\u5757")
    @ApiImplicitParam(name="moduleId", type="path", value="\u6a21\u5757ID")
    @GetMapping(value={"/{moduleId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public ProjectModule getProjectModule(@PathVariable String moduleId) {
        return this.projectModuleService.getProjectModule(moduleId);
    }

    @ApiOperation(value="\u67e5\u8be2\u6a21\u5757\u5173\u8054\u7684\u8868\u548c\u89c6\u56fe")
    @ApiImplicitParam(name="moduleId", type="path", value="\u6a21\u5757ID")
    @GetMapping(value={"/tables/{moduleId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public List<TableStruct> listModuleTables(@PathVariable String moduleId) {
        return this.projectModuleService.listModuleTables(moduleId);
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u6a21\u5757", notes="\u5220\u9664\u5355\u4e2a\u6a21\u5757\uff0c\u4e0d\u4f1a\u5220\u9664\u8868")
    @ApiImplicitParam(name="moduleId", type="path", value="\u6a21\u5757ID")
    @DeleteMapping(value={"/{moduleId}"})
    @WrapUpResponseBody
    public void deleteProjectModule(@PathVariable String moduleId) {
        this.projectModuleService.deleteProjectModule(moduleId);
    }

    @ApiOperation(value="\u65b0\u5efa\u6a21\u5757\u6570\u636e")
    @PostMapping
    @WrapUpResponseBody
    public ProjectModule saveProjectModule(@RequestBody ProjectModule projectModule) {
        this.projectModuleService.saveProjectModule(projectModule);
        return projectModule;
    }

    @ApiOperation(value="\u4fee\u6539\u6a21\u5757\u6570\u636e")
    @PutMapping
    @WrapUpResponseBody
    public void updateProjectModule(@RequestBody ProjectModule projectModule) {
        this.projectModuleService.updateProjectModule(projectModule);
    }

    @ApiOperation(value="fork\u6a21\u5757\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", type="path", value="\u6a21\u5757ID"), @ApiImplicitParam(name="projectId", type="path", value="\u76ee\u6807\u9879\u76eeID\uff0c\u5fc5\u987b\u662f\u5f53\u524d\u7528\u6237\u53ef\u4ee5\u64cd\u4f5c\u7684\u9879\u76ee")})
    @PostMapping(value={"/fork/{moduleId}/{projectId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public ProjectModule forkModuleInfo(@PathVariable String moduleId, @PathVariable String projectId, HttpServletRequest request) {
        CentitUserDetails ud = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (ud == null) {
            throw new ObjectException(403, "Session\u8fc7\u671f\u6216\u8005\u7528\u6237\u6ca1\u6709\u767b\u5f55\u3002");
        }
        return this.projectModuleService.forkModule(ud, moduleId, projectId);
    }

    @ApiOperation(value="\u751f\u6210\u811a\u672c", notes="\u751f\u6210\u811a\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", type="path", value="\u6a21\u5757ID"), @ApiImplicitParam(name="dbtype", type="query", value="\u6570\u636e\u7c7b\u522b")})
    @GetMapping(value={"/sql/{moduleId}"})
    @WrapUpResponseBody
    public String createSql(@PathVariable String moduleId, String dbtype) {
        return this.projectModuleService.makeCreateSql(moduleId, DBType.mapDBType((String)dbtype, (DBType)DBType.MySql));
    }

    @ApiOperation(value="DDL\u811a\u672c\u4ee5\u6587\u4ef6\u65b9\u5f0f\u8fd4\u56de", notes="DDL\u811a\u672c\u4ee5\u6587\u4ef6\u65b9\u5f0f\u8fd4\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", type="path", value="\u6a21\u5757ID"), @ApiImplicitParam(name="dbtype", type="query", value="\u6570\u636e\u7c7b\u522b")})
    @GetMapping(value={"/ddl/{moduleId}"})
    public void downloadDDL(@PathVariable String moduleId, String dbtype, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ProjectModule module = this.projectModuleService.getProjectModule(moduleId);
        String ddl = this.projectModuleService.makeCreateSql(moduleId, DBType.mapDBType((String)dbtype, (DBType)DBType.MySql));
        String fileName = module.getModuleName() + ".sql";
        ByteArrayInputStream bis = new ByteArrayInputStream(ddl.getBytes(StandardCharsets.UTF_8));
        UploadDownloadUtils.downloadFile((InputStream)bis, (String)fileName, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u5bfc\u51fa\u9879\u76ee\u7684\u8868\u7ed3\u6784\u4fe1\u606f", notes="\u5bfc\u51fa\u9879\u76ee\u7684\u8868\u7ed3\u6784\u4fe1\u606f")
    @ApiImplicitParam(name="moduleId", type="path", value="\u6a21\u5757ID")
    @GetMapping(value={"/export/{moduleId}"})
    public void exportModule(@PathVariable String moduleId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ProjectModule module = this.projectModuleService.getProjectModule(moduleId);
        if (module == null) {
            throw new ObjectException(604, "\u6a21\u5757\uff1a" + moduleId + " \u4e0d\u5b58\u5728\uff01");
        }
        JSONObject json = this.projectModuleService.exportModule(moduleId);
        String fileName = module.getModuleName() + ".json";
        ByteArrayInputStream bis = new ByteArrayInputStream(json.toJSONString(new JSONWriter.Feature[0]).getBytes(StandardCharsets.UTF_8));
        UploadDownloadUtils.downloadFile((InputStream)bis, (String)fileName, (HttpServletRequest)request, (HttpServletResponse)response);
    }
}

