package com.centit.tablestore.service;

import com.alibaba.fastjson2.JSONObject;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.ProjectHistory;

import java.util.List;
import java.util.Map;

public interface ProjectHistoryService {

    void saveProjectHistory(ProjectHistory historyInfo);

    void updateProjectHistory(ProjectHistory historyInfo);

    void deleteProjectHistory(String historyId);

    ProjectHistory getProjectHistory(String historyId);

    void restoreProjectHistory(String historyId);

    List<ProjectHistory> listProjectHistory(Map<String, Object> params, PageDesc pageDesc);

    void restoreProject(String projectId, JSONObject projectInfo);

    void mergeProject(String projectId, JSONObject projectInfo);
}
