package com.centit.tablestore.po;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 项目团队
 */
@ApiModel
@Data
@Entity
@Table(name = "TS_PROJECT_TEAM")
public class ProjectTeam implements java.io.Serializable {
    private static final long serialVersionUID = 1L;

    @EmbeddedId
    ProjectTeamId ptId;

    @Column(name = "MEMBER_NAME")
    @ApiModelProperty(value = "成员姓名")
    private String memberName;

    @Column(name = "CREATE_TIME")
    @ApiModelProperty(value = "创建时间")
    @ValueGenerator(strategy = GeneratorType.FUNCTION, value = "today()")
    private Date createTIme;

    public ProjectTeam(){
    }
    public ProjectTeam(String projectId, String userCode){
        ptId = new ProjectTeamId(projectId, userCode);
        createTIme = DatetimeOpt.currentUtilDate();
    }

    public String getProjectId() {
        if(ptId==null) return null;
        return ptId.getProjectId();
    }

    public void setProjectId(String projectId) {
        if(ptId==null) ptId = new ProjectTeamId();
        ptId.setProjectId(projectId);
    }

    public String getProjectMember() {
        if(ptId==null) return null;
        return ptId.getProjectMember();
    }

    public void setProjectMember(String projectMember) {
        if(ptId==null) ptId = new ProjectTeamId();
        ptId.setProjectMember(projectMember);
    }
}
