package com.centit.tablestore.po;

import com.alibaba.fastjson2.JSONObject;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.persistence.*;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

@ApiModel
@Entity
@Data
@Table(name = "TS_PROJECT_HISTORY")
public class ProjectHistory implements Serializable {
    private static final long serialVersionUID = 1;

    @Id
    @Column(name = "HISTORY_ID")
    @ApiModelProperty(value = "id", hidden = true)
    @NotBlank(message = "字段不能为空")
    @ValueGenerator(strategy = GeneratorType.UUID)
    private  String historyId;

    @ApiModelProperty(value = "关联项目id")
    @Column(name = "PROJECT_ID")
    @Length(max = 32, message = "字段长度不能大于{max}")
    private  String projectId;


    @ApiModelProperty(value = "结构内容")
    @Column(name = "STRUCT_CONTENT")
    @Basic(fetch = FetchType.LAZY)
    private JSONObject structContent;

    @ApiModelProperty(value = "标签")
    @Column(name = "HISTORY_LABEL")
    @Length(max = 100, message = "字段长度不能大于{max}")
    private  String historyLabel;

    @ApiModelProperty(value = "备注")
    @Column(name = "HISTORY_MEMO")
    @Length(max = 500, message = "字段长度不能大于{max}")
    private  String  historyMemo;

    @ApiModelProperty(value = "提交时间", hidden = true)
    @ValueGenerator(strategy = GeneratorType.FUNCTION, value = "today()")
    @Column(name = "PUSH_TIME")
    private Date pushTime;

    @ApiModelProperty(value = "提交人")
    @Column(name = "PUSH_USER")
    @Length(max = 32, message = "字段长度不能大于{max}")
    private  String pushUser;

}
