package com.centit.tablestore.po;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 项目团队
 */
@ApiModel
@Data
@Entity
@Table(name = "TS_PROJECT_FOLLOWER")
public class ProjectFollower implements java.io.Serializable {
    private static final long serialVersionUID = 1L;

    @EmbeddedId
    ProjectFollowerId pfId;

    @Column(name = "FOLLOWER_NAME")
    @ApiModelProperty(value = "关注人员姓名")
    private String followerName;

    @Column(name = "FOLLOWER_CATALOG")
    @ApiModelProperty(value = "关注类别，这个暂时可以空着")
    private String followerCatalog;

    @Column(name = "CREATE_TIME")
    @ApiModelProperty(value = "创建时间")
    @ValueGenerator(strategy = GeneratorType.FUNCTION, value = "today()")
    private Date createTIme;

    public ProjectFollower(){
    }
    public ProjectFollower(String projectId, String userCode){
        pfId = new ProjectFollowerId(projectId, userCode);
        createTIme = DatetimeOpt.currentUtilDate();
    }

    public String getProjectId() {
        if(pfId==null) return null;
        return pfId.getProjectId();
    }

    public void setProjectId(String projectId) {
        if(pfId==null)
            pfId = new ProjectFollowerId();
        pfId.setProjectId(projectId);
    }

    public String getProjectFollower() {
        if(pfId==null) return null;
        return pfId.getProjectFollower();
    }

    public void setProjectFollower(String projectFollower) {
        if(pfId==null) pfId = new ProjectFollowerId();
        pfId.setProjectFollower(projectFollower);
    }
}
