package com.centit.tablestore.dao;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.TableStruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class TableStructDao extends BaseDaoImpl<TableStruct, String> {

    @Override
    public Map<String, String> getFilterField() {
        /*Map<String, String> filterField = new HashMap<>();
        filterField.put("fulltextIndex" , "match(FULLTEXT_INDEX) against(:fulltextIndex)");
        return filterField;*/
        return null;
    }

    public boolean isTableExist(String projectId, String tableName) {
        String sql = " SELECT COUNT(1) FROM TS_TABLE_STRUCT WHERE PROJECT_ID = ? and LOWER(TABLE_NAME) = ? ";
        return NumberBaseOpt.castObjectToInteger(DatabaseOptUtils.getScalarObjectQuery(
                this, sql, new Object[]{projectId, tableName.toLowerCase()})) > 0;
    }

    public JSONArray statTables(String keyWords){
        return DatabaseOptUtils.listObjectsBySqlAsJson(this,
                "select a.INDUSTRY_CATEGORY, count(1) as TABLE_SUM " +
                        "from TS_PROJECT_INFO a join TS_TABLE_STRUCT b on a.PROJECT_ID=b.PROJECT_ID " +
                        "where match(FULLTEXT_INDEX) against(?) " + // against(? IN BOOLEAN MODE)
                        "group by a.INDUSTRY_CATEGORY" ,
                new Object[] {keyWords});
    }


    public JSONArray searchTables(String keyWords, String industryCategory, PageDesc pageDesc){
        /**
         * 目前只做MySql的版本
         */
        int offset = pageDesc.getRowStart(), maxsize = pageDesc.getPageSize();
        String sql = "select b.TABLE_ID, b.PROJECT_ID, a.PROJECT_NAME, b.TABLE_TYPE, b.TABLE_NAME, b.TABLE_LABEL_NAME, " +
                "b.TABLE_COMMENT, b.CREATOR_CODE, b.CREATOR_NAME, b.LAST_UPDATE_TIME " +
                "from TS_PROJECT_INFO a join TS_TABLE_STRUCT b on a.PROJECT_ID=b.PROJECT_ID " +
                "where match(FULLTEXT_INDEX) against(?) "; // against(? IN BOOLEAN MODE)
        String  limitSql =  offset > 0 ? " limit " + offset+ "," + maxsize: " limit " + maxsize;
        String orderBySql =  " order by a.SORT_SCORE desc ";

        JSONArray jsonArray = null;
        if(StringUtils.isBlank(industryCategory)) {
            jsonArray = DatabaseOptUtils.listObjectsBySqlAsJson(this,
                    sql + orderBySql + limitSql,
                    new Object[]{keyWords});
        } else {
            jsonArray = DatabaseOptUtils.listObjectsBySqlAsJson(this,
                    sql + " and a.INDUSTRY_CATEGORY = ?" + orderBySql + limitSql,
                    new Object[]{keyWords , industryCategory});
        }
        // total size 应该从前端代入，没有必要在查一次
        int returnObject =  jsonArray==null? 0: jsonArray.size();
        if(returnObject<maxsize){
            pageDesc.setTotalRows(offset + returnObject);
        } else {
            if(offset + returnObject + 1 > pageDesc.getTotalRows()){
                pageDesc.setTotalRows(offset + returnObject + 1);
            }
        }
        return jsonArray;
    }

    public void deleteProjectTable(String projectId) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap("projectId", projectId));
    }

    // 这个tableName 就是 tableCode 需要忽略大小写
    // listObjectsBySql 默认不包括lob字段
    public TableStruct getTableByName(String projectId, String tableName){
        Pair<String, TableField[]> querySql =  GeneralJsonObjectDao.buildSelectSqlWithFields(
                JpaMetadata.fetchTableMapInfo(this.getPoClass()),
                null, false, "PROJECT_ID = ? and LOWER(TABLE_NAME) = ?", false, null);

        List<TableStruct> tables = this.listObjectsBySql(querySql.getLeft(),
                new Object[] {projectId, tableName.toLowerCase()});
        if(tables==null || tables.size()<1)
            return null;
        return tables.get(0);
    }

    public List<TableStruct> listProjectTableWithColumn(String projectId){
        Pair<String, TableField[]> querySql =  GeneralJsonObjectDao.buildSelectSqlWithFields(
                JpaMetadata.fetchTableMapInfo(this.getPoClass()),
                null, false, "PROJECT_ID = ?", false, null);

        return this.listObjectsBySql(querySql.getLeft(), new Object[] {projectId});
    }

    public List<TableStruct> listTablesByIds(List<String> tableIds){
        Pair<String, TableField[]> querySql =  GeneralJsonObjectDao.buildSelectSqlWithFields(
                JpaMetadata.fetchTableMapInfo(this.getPoClass()),
                null, false, "TABLE_ID in (:ids)", false, null);

        return this.listObjectsBySql(querySql.getLeft(), CollectionsOpt.createHashMap("ids",tableIds));
    }

    public TableStruct mergeTable(TableStruct ts, String projectId) {
        //复制表
        TableStruct dbTS = this.getTableByName(projectId, ts.getTableName());
        if(dbTS!=null){
            dbTS.setTableLabelName(ts.getTableLabelName());
            dbTS.setTableComment(ts.getTableComment());
            dbTS.setTableType(ts.getTableType());
            dbTS.setMetadataJson(ts.getMetadataJson());
            this.updateObject(dbTS);
            return dbTS;
        } else {
            //检查是否有同名的表
            ts.setProjectId(projectId);
            this.saveNewObject(ts);
            return ts;
        }
    }
}
