package com.centit.tablestore.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.tablestore.po.ProjectModule;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class ProjectModuleDao extends BaseDaoImpl<ProjectModule, String> {

    @Override
    public Map<String, String> getFilterField() {
        return null;
    }

    public void deleteProjectModule(String projectId) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap("projectId", projectId));
    }

    public List<ProjectModule> listProjectModuleWithDesign(String projectId){
        Pair<String, TableField[]> querySql =  GeneralJsonObjectDao.buildSelectSqlWithFields(
                JpaMetadata.fetchTableMapInfo(this.getPoClass()),
                null, false, "PROJECT_ID = ? ", false, null);
        return this.listObjectsBySql(querySql.getLeft(), new Object[] {projectId});
    }

    public ProjectModule getModuleByName(String projectId, String moduleName){
        Pair<String, TableField[]> querySql =  GeneralJsonObjectDao.buildSelectSqlWithFields(
                JpaMetadata.fetchTableMapInfo(this.getPoClass()),
                null, false, "PROJECT_ID = ? and MODULE_NAME = ?", false, null);

        List<ProjectModule> modules = this.listObjectsBySql(querySql.getLeft(),
                new Object[] {projectId, moduleName});
        if(modules==null || modules.size()<1)
            return null;
        return modules.get(0);
    }

    public ProjectModule mergeProjectModule(ProjectModule projectModule) {
        ProjectModule dbMD = this.getModuleByName(projectModule.getProjectId(), projectModule.getModuleName());
        if(dbMD!=null){
            dbMD.setModuleDesign(projectModule.getModuleDesign());
            dbMD.setModuleDesc(projectModule.getModuleDesc());
            this.updateObject(dbMD);
            return dbMD;
        } else {
            //检查是否有同名的表
            this.saveNewObject(projectModule);
            return projectModule;
        }
    }
}
