package com.centit.tablestore.service.impl;

import com.centit.support.database.metadata.PdmReader;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.tablestore.po.TableStruct;
import org.apache.commons.lang3.tuple.Pair;

import java.util.ArrayList;
import java.util.List;

public abstract class PdmTableInfoUtils {

    public static List<Pair<String, String>> listTablesInPdm(String pdmFilePath) {
        PdmReader pdmReader = new PdmReader();
        if(!pdmReader.loadPdmFile(pdmFilePath))
            return null;

        return pdmReader.getAllTableCode();
    }

    public static TableStruct convertTableInfoToStruct(SimpleTableInfo pdmTable ) {
        TableStruct metaTable = new TableStruct();
        metaTable.setTableName(pdmTable.getTableName());
        metaTable.setTableLabelName(pdmTable.getTableLabelName());
        metaTable.setTableComment(pdmTable.getTableComment());

        List<SimpleTableField> fields = new ArrayList<>();
        for(SimpleTableField field : pdmTable.getColumns()){
            SimpleTableField mdColumn = new SimpleTableField();
            mdColumn.setColumnName(field.getColumnName());
            mdColumn.setFieldType(field.getColumnType());
            mdColumn.setColumnComment(field.getColumnComment());
            mdColumn.setMaxLength(field.getMaxLength());
            mdColumn.setScale(field.getScale());
            mdColumn.setMandatory(field.isMandatory());
            mdColumn.setPrimaryKey(field.isPrimaryKey());

            fields.add(mdColumn);
        }
        metaTable.setTableColumns(fields);
        return metaTable;
    }

    public static List<SimpleTableInfo> getTableNameFromPdm(String pdmFilePath) {
        PdmReader pdmReader = new PdmReader();
        if(!pdmReader.loadPdmFile(pdmFilePath))
            return null;
        List<SimpleTableInfo> pdmTables = new ArrayList<>();
        List<Pair<String,String>> tabNames = pdmReader.getAllTableCode();
        for (Pair<String, String> tabName : tabNames) {
            SimpleTableInfo pdmTable = new SimpleTableInfo();
            pdmTable.setTableName(tabName.getKey());
            pdmTable.setTableLabelName(tabName.getValue());
            pdmTables.add(pdmTable);
        }
        return pdmTables;
    }

    public static List<SimpleTableInfo> importTableFromPdm(String pdmFilePath) {
        PdmReader pdmReader = new PdmReader();
        if(!pdmReader.loadPdmFile(pdmFilePath))
            return null;
        List<SimpleTableInfo> pdmTables = new ArrayList<>();
        List<Pair<String,String>> tabNames = pdmReader.getAllTableCode();
        for (Pair<String, String> tabName : tabNames) {
            SimpleTableInfo pdmTable = pdmReader.getTableMetadata(tabName.getKey());
            pdmTables.add(pdmTable);
        }
        return pdmTables;
    }

    public static List<TableStruct> importTableFromPdm(String pdmFilePath, List<String> tables) {
        PdmReader pdmReader = new PdmReader();
        if(!pdmReader.loadPdmFile(pdmFilePath))
            return null;
        List<TableStruct> pdmTables = new ArrayList<>();
        for (String table : tables) {
            SimpleTableInfo pdmTable = pdmReader.getTableMetadata(table);
            if(pdmTable!=null) {
                pdmTables.add(convertTableInfoToStruct(pdmTable));
            }
        }
        return pdmTables;
    }

}
