package com.centit.tablestore.service;

import com.centit.framework.security.model.CentitUserDetails;
import com.centit.support.database.utils.DBType;
import com.centit.tablestore.po.ProjectModule;
import com.centit.tablestore.po.TableStruct;

import java.util.List;

public interface ProjectModuleService {

    void saveProjectModule(ProjectModule projectModule);

    void updateProjectModule(ProjectModule projectModule);

    void deleteProjectModule(String moduleId);

    ProjectModule getProjectModule(String moduleId);

    List<ProjectModule> listProjectModules(String projectId);

    List<TableStruct> listModuleTables(String moduleId);

    ProjectModule forkModule(CentitUserDetails userDetails, String moduleId, String projectId);

    String makeCreateSql(String moduleId, DBType dbType);
}
