package com.centit.tablestore.po;

import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 项目信息
 */
@ApiModel
@Data
@Entity
@Table(name = "TS_PROJECT_INFO")
public class ProjectInfo implements java.io.Serializable {
    private static final long serialVersionUID = 1L;

    public ProjectInfo(){
        clearSortScore();
    }
    public void clearSortScore(){
        this.tableForkedTimes = 0l;
        this.projectForkedTimes = 0l;
        this.tableViewedTimes = 0l;
        this.sortScore = 0l;
    }

    public void calcSortScore(){
        this.sortScore = this.projectForkedTimes * 10 + this.tableForkedTimes * 2 + this.tableViewedTimes ;
    }
    /**
     * 表ID 表编号
     */
    @Id
    @Column(name = "PROJECT_ID")
    @ApiModelProperty(value = "项目ID")
    @ValueGenerator(strategy = GeneratorType.UUID22)
    private String projectId;

    @Column(name = "PROJECT_NAME")
    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @Column(name = "FORK_PROJECT_ID")
    @ApiModelProperty(value = "FORK项目ID, 自创的为空")
    private String forkProject;

    @Column(name = "INDUSTRY_CATEGORY")
    @ApiModelProperty(value = "行业类别")
    private String industryCategory;

    @Column(name = "PROJECT_DESC")
    @ApiModelProperty(value = "项目描述")
    private String projectDesc;

    @Column(name = "CREATOR_CODE")
    @ApiModelProperty(value = "项目创建人")
    private String creatorCode;

    @Column(name = "CREATOR_NAME")
    @ApiModelProperty(value = "创建人姓名")
    private String creatorName;

    @Column(name = "LAST_UPDATE_TIME")
    @ApiModelProperty(value = "最后更新时间")
    @ValueGenerator(strategy = GeneratorType.FUNCTION, condition = GeneratorCondition.ALWAYS, value = "today()")
    private Date lastUpdateTIme;


    @Column(name = "TABLE_FORKED_TIMES")
    @ApiModelProperty(value = "表被fork次数")
    private long tableForkedTimes;

    @Column(name = "PROJECT_FORKED_TIMES")
    @ApiModelProperty(value = "项目被fork次数")
    private long projectForkedTimes;

    @Column(name = "TABLE_VIEWED_TIMES")
    @ApiModelProperty(value = "表被查看次数")
    private long tableViewedTimes;

    @Column(name = "SORT_SCORE")
    @ApiModelProperty(value = "排序权重得分")
    private long sortScore;

}
