package com.centit.tablestore.dao;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.tablestore.po.TableStruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Map;

@Repository
public class TableStructDao extends BaseDaoImpl<TableStruct, String> {

    @Override
    public Map<String, String> getFilterField() {
        /*Map<String, String> filterField = new HashMap<>();
        filterField.put("fulltextIndex" , "match(FULLTEXT_INDEX) against(:fulltextIndex)");
        return filterField;*/
        return null;
    }

    public JSONArray statTables(String keyWords){
        return DatabaseOptUtils.listObjectsBySqlAsJson(this,
                "select a.INDUSTRY_CATEGORY, count(1) as TABLE_SUM " +
                        "from TS_PROJECT_INFO a join TS_TABLE_STRUCT b on a.PROJECT_ID=b.PROJECT_ID " +
                        "where match(FULLTEXT_INDEX) against(? IN BOOLEAN MODE) " +
                        "group by a.INDUSTRY_CATEGORY" ,
                new Object[] {keyWords});
    }


    public JSONArray searchTables(String keyWords, String industryCategory, PageDesc pageDesc){
        /**
         * 目前只做MySql的版本
         */
        int offset = pageDesc.getRowStart(), maxsize = pageDesc.getPageSize();
        String sql = "select b.TABLE_ID, b.PROJECT_ID, a.PROJECT_NAME, b.TABLE_TYPE, b.TABLE_NAME, b.TABLE_LABEL_NAME, " +
                "b.TABLE_COMMENT, b.CREATOR_CODE, b.CREATOR_NAME, b.LAST_UPDATE_TIME " +
                "from TS_PROJECT_INFO a join TS_TABLE_STRUCT b on a.PROJECT_ID=b.PROJECT_ID " +
                "where match(FULLTEXT_INDEX) against(? IN BOOLEAN MODE) ";
        String  limitSql =  offset > 0 ? " limit " + offset+ "," + maxsize: " limit " + maxsize;
        String orderBySql =  " order by a.SORT_SCORE desc ";

        JSONArray jsonArray = null;
        if(StringUtils.isBlank(industryCategory)) {
            jsonArray = DatabaseOptUtils.listObjectsBySqlAsJson(this,
                    sql + orderBySql + limitSql,
                    new Object[]{keyWords});
        } else {
            jsonArray = DatabaseOptUtils.listObjectsBySqlAsJson(this,
                    sql + " and a.INDUSTRY_CATEGORY = ?" + orderBySql + limitSql,
                    new Object[]{keyWords , industryCategory});
        }
        // total size 应该从前端代入，没有必要在查一次
        int returnObject =  jsonArray==null? 0: jsonArray.size();
        if(returnObject<maxsize){
            pageDesc.setTotalRows(offset + returnObject);
        } else {
            if(offset + returnObject + 1 > pageDesc.getTotalRows()){
                pageDesc.setTotalRows(offset + returnObject + 1);
            }
        }
        return jsonArray;
    }

    public void deleteProjectTable(String projectId) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap("projectId", projectId));
    }

    public TableStruct getTableByName(String projectId, String tableName){
        return super.getObjectByProperties(
                CollectionsOpt.createHashMap("projectId", projectId,
                        "tableName",tableName));
    }
}
