package com.centit.tablestore.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.tablestore.po.ProjectInfo;
import org.springframework.stereotype.Repository;

import java.util.Map;

@Repository
public class ProjectInfoDao extends BaseDaoImpl<ProjectInfo, String> {

    @Override
    public Map<String, String> getFilterField() {
        return null;
    }

    public boolean checkOwner(String projectId, String userCode){
        return NumberBaseOpt.castObjectToInteger(
                DatabaseOptUtils.getScalarObjectQuery( this,
                "select count(1) as projectSum from TS_PROJECT_INFO a " +
                        "where a.PROJECT_ID = ? and a.CREATOR_CODE = ?",
                new Object[]{projectId, userCode}), 0) > 0;
    }

    public void updateSortScore(ProjectInfo projectInfo){
        projectInfo.calcSortScore();
        DatabaseOptUtils.doExecuteSql(this,
                "update TS_PROJECT_INFO set TABLE_FORKED_TIMES =?, PROJECT_FORKED_TIMES = ?," +
                        "TABLE_VIEWED_TIMES= ?, SORT_SCORE= ? where projectId =?",
                new Object[]{projectInfo.getTableForkedTimes(), projectInfo.getProjectForkedTimes(),
                        projectInfo.getTableViewedTimes(), projectInfo.getSortScore(), projectInfo.getProjectId()});
    }
}
